package com.biz.crm.dms.business.exchange.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.dms.business.exchange.local.entity.ExchangeFileEntity;
import com.biz.crm.dms.business.exchange.local.mapper.ExchangeFileMapper;
import java.util.List;

import org.springframework.stereotype.Component;

/**
 * 换货单附件子表(repository)
 *
 * @author xi.peng
 * @since 2022-07-06 19:00:33
 */
@Component
public class ExchangeFileRepository extends ServiceImpl<ExchangeFileMapper, ExchangeFileEntity> {

  /**
   * 根据换货单编码获取详情集合
   *
   * @param exchangeCode
   * @return
   */
  public List<ExchangeFileEntity> findByExchangeCode(String exchangeCode) {
    return this.lambdaQuery()
        .eq(ExchangeFileEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(ExchangeFileEntity::getExchangeCode, exchangeCode).list();
  }

  /**
   * 根据换货单编码集合批量删除
   *
   * @param exchangeCodes 换货单编码集合
   */
  public void removeByExchangeCodes(List<String> exchangeCodes) {
    this.lambdaUpdate().in(ExchangeFileEntity::getExchangeCode, exchangeCodes).remove();
  }
}
