package com.biz.crm.dms.business.exchange.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.exchange.local.repository.ExchangeFileRepository;
import com.biz.crm.dms.business.exchange.local.entity.ExchangeFileEntity;
import com.biz.crm.dms.business.exchange.sdk.dto.ExchangeFileDto;
import com.biz.crm.dms.business.exchange.sdk.service.ExchangeFileVoService;
import com.biz.crm.dms.business.exchange.sdk.vo.ExchangeFileVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

import lombok.extern.slf4j.Slf4j;

/**
 * 换货单附件子表(DmsOrderExchangeFile)表服务实现类
 *
 * @author xi.peng
 * @since 2022-07-06 19:00:33
 */
@Slf4j
@Service
public class ExchangeFileVoServiceImpl implements ExchangeFileVoService {

  @Autowired(required = false)
  private ExchangeFileRepository exchangeFileRepository;

  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<ExchangeFileVo> findByExchangeCode(String exchangeCodes) {
    if (StringUtils.isBlank(exchangeCodes)) {
      return null;
    }
    List<ExchangeFileEntity> entities = this.exchangeFileRepository.findByExchangeCode(exchangeCodes);
    if (CollectionUtils.isEmpty(entities)) {
      return null;
    }
    return (List<ExchangeFileVo>) this.nebulaToolkitService.copyCollectionByWhiteList(entities, ExchangeFileEntity.class, ExchangeFileVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  @Transactional
  public void createBatch(String exchangeCode, List<ExchangeFileDto> dtoList) {
    if (CollectionUtils.isEmpty(dtoList)) {
      return;
    }
    //删除原来的重新创建
    this.exchangeFileRepository.removeByExchangeCodes(Collections.singletonList(exchangeCode));
    dtoList.forEach(dto->{
      dto.setTenantCode(TenantUtils.getTenantCode());
      dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
      dto.setExchangeCode(exchangeCode);
      this.createValidation(dto);
    });
    List<ExchangeFileEntity> entities = (List<ExchangeFileEntity>) this.nebulaToolkitService.copyCollectionByWhiteList(dtoList, ExchangeFileDto.class, ExchangeFileEntity.class, HashSet.class, ArrayList.class);
    this.exchangeFileRepository.saveBatch(entities);
  }

  @Override
  @Transactional
  public void updateBatch(List<ExchangeFileDto> dtoList) {
    Validate.notEmpty(dtoList, "换货单附件集合不能为空！");
    List<ExchangeFileEntity> differenceEntities = new ArrayList<>();
    dtoList.forEach(dto->{
      this.updateValidation(dto);
      ExchangeFileEntity entity = this.nebulaToolkitService.copyObjectByWhiteList(dto, ExchangeFileEntity.class, HashSet.class, ArrayList.class);
      differenceEntities.add(entity);
    });
    // 先删除
    List<String> exchangeCodes = dtoList.stream().map(ExchangeFileDto::getExchangeCode).distinct().collect(Collectors.toList());
    this.exchangeFileRepository.removeByExchangeCodes(exchangeCodes);
    // 再创建
    this.exchangeFileRepository.saveBatch(differenceEntities);
  }

  private void createValidation(ExchangeFileDto dto) {
    // TODO 具体实现
    this.validation(dto);
  }

  private void updateValidation(ExchangeFileDto dto) {
    // TODO 具体实现
    this.validation(dto);
    Validate.notBlank(dto.getId(), "ID不能为空");
  }

  private void validation(ExchangeFileDto dto) {
    // TODO 具体实现
    Validate.notNull(dto, "user对象不能为空");
  }
}
