package com.biz.crm.dms.business.exchange.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.delivery.sdk.dto.DeliveryUnshippedPageDto;
import com.biz.crm.dms.business.delivery.sdk.service.DeliveryUnshippedVoService;
import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryUnshippedVo;
import com.biz.crm.dms.business.exchange.sdk.service.ExchangeableVoService;
import com.biz.crm.dms.business.exchange.sdk.vo.ExchangeableVo;
import com.biz.crm.dms.business.returned.goods.sdk.service.goods.ReturnedGoodsVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 查询没有发货完毕且没有退完货的订单信息
 * @author pengxi
 */
@Slf4j
@Service
public class ExchangeableVoServiceImpl implements ExchangeableVoService {

  @Autowired(required = false)
  private DeliveryUnshippedVoService deliveryUnshippedVoService;

  @Autowired(required = false)
  private ReturnedGoodsVoService returnedGoodsVoService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<ExchangeableVo> findByOrderUnshippedPageDto(Pageable pageable, DeliveryUnshippedPageDto deliveryUnshippedPageDto) {
    if (Objects.isNull(deliveryUnshippedPageDto)) {
      deliveryUnshippedPageDto = new DeliveryUnshippedPageDto();
    }

    Page<DeliveryUnshippedVo> orderPage = this.deliveryUnshippedVoService.findByOrderUnshippedPageDto(pageable, deliveryUnshippedPageDto);
    if (orderPage==null || CollectionUtils.isEmpty(orderPage.getRecords())) {
      return new Page<>();
    }
    List<DeliveryUnshippedVo> records = orderPage.getRecords();
    List<ExchangeableVo> exchangeableVoList = (List<ExchangeableVo>) this.nebulaToolkitService.copyCollectionByBlankList(records, DeliveryUnshippedVo.class, ExchangeableVo.class, HashSet.class, LinkedList.class);

    // 查询退货数量总和
    List<String> orderCodes = exchangeableVoList.stream().map(DeliveryUnshippedVo::getOrderCode).distinct().collect(Collectors.toList());
    Map<String, BigDecimal> returnQuantityMap = this.returnedGoodsVoService.findQuantityByOrderCodes(orderCodes);
    // 退货数量
    if (!returnQuantityMap.isEmpty()) {
      exchangeableVoList.forEach(o->{
        BigDecimal returnQuantity = returnQuantityMap.get(o.getOrderCode())==null ? BigDecimal.ZERO : returnQuantityMap.get(o.getOrderCode());
        // 比较之前确保a,b对象不能为空
        if (returnQuantity.compareTo(o.getDeliveryQuantity()) == -1) {
          //a.compareTo(b)==-1，表示"a小于b";
          o.setExchangeable(Boolean.TRUE);
        }
      });
    }
    Page<ExchangeableVo> exchangeableVoPage = new Page<>(orderPage.getCurrent(), orderPage.getSize(), orderPage.getTotal());
    exchangeableVoPage.setRecords(exchangeableVoList);
    return exchangeableVoPage;
  }

}
