/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.exchange.local.service.helper;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CostPoolCapitalDto;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.CapitalAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.PoolTypeEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditPayDto;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustOperateEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CreditPoolTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolGroupEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolPayTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolUseTypeEnum;
import com.biz.crm.dms.business.costpool.sdk.service.CostPoolVoService;
import com.biz.crm.dms.business.exchange.sdk.vo.ExchangeDifferenceVo;
import com.biz.crm.dms.business.exchange.sdk.vo.ExchangeVo;
import java.math.BigDecimal;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ExchangeHelper {
    @Autowired(required=false)
    private CostPoolVoService costPoolVoService;

    public void upAccount(ExchangeVo exchangeVo) {
        JSONArray array = new JSONArray();
        exchangeVo.getDifferenceList().forEach(differenceVo -> {
            if (BigDecimal.ZERO.compareTo(differenceVo.getExchangeAmount()) > -1) {
                return;
            }
            if (CreditPoolTypeEnum.CREDIT.getDictCode().equals(differenceVo.getPoolType())) {
                CreditPayDto creditPayDto = this.getCreditDto(exchangeVo, (ExchangeDifferenceVo)differenceVo);
                array.add((Object)creditPayDto);
            }
            if (PoolTypeEnum.CAPITAL.getDictCode().equals(differenceVo.getPoolType())) {
                CostPoolCapitalDto costPoolCapitalDto = this.getCapitalDto(exchangeVo, (ExchangeDifferenceVo)differenceVo);
                array.add((Object)costPoolCapitalDto);
            }
            if (com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolTypeEnum.DISCOUNT.getDictCode().equals(differenceVo.getPoolType())) {
                CostPoolDiscountDto discountDto = this.getDiscountDto(exchangeVo, (ExchangeDifferenceVo)differenceVo);
                array.add((Object)discountDto);
            }
            if (com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolTypeEnum.Replenishment.getDictCode().equals(differenceVo.getPoolType())) {
                CostPoolReplenishmentDto replenishmentDto = this.getReplenishmentDto(exchangeVo, (ExchangeDifferenceVo)differenceVo);
                array.add((Object)replenishmentDto);
            }
        });
        if (CollectionUtils.isEmpty((Collection)array)) {
            return;
        }
        this.costPoolVoService.handleAdjust(array);
    }

    private CostPoolReplenishmentDto getReplenishmentDto(ExchangeVo exchangeVo, ExchangeDifferenceVo differenceVo) {
        BigDecimal replenishmentAmount = differenceVo.getExchangeAmount();
        CostPoolReplenishmentDto dto = new CostPoolReplenishmentDto();
        dto.setPoolCode(differenceVo.getSourceCode());
        dto.setAmount(replenishmentAmount);
        dto.setCustomerCode(exchangeVo.getCustomerCode());
        dto.setFromCode(exchangeVo.getExchangeCode());
        dto.setFromDesc(com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeEnum.RETURNED_GOODS_AMOUNT.getValue());
        dto.setPoolGroup(com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolGroupEnum.DEFAULT.getDictCode());
        dto.setPayType(com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolPayTypeEnum.Replenishment.getDictCode());
        dto.setUseType(PoolUseTypeEnum.DEFAULT.getDictCode());
        dto.setOperationType(com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeEnum.RETURNED_GOODS_AMOUNT.getDictCode());
        dto.setPoolType(com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolTypeEnum.Replenishment.getDictCode());
        return dto;
    }

    private CostPoolDiscountDto getDiscountDto(ExchangeVo exchangeVo, ExchangeDifferenceVo differenceVo) {
        BigDecimal discountAmount = differenceVo.getExchangeAmount();
        CostPoolDiscountDto dto = new CostPoolDiscountDto();
        dto.setPoolType(com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolTypeEnum.DISCOUNT.getKey());
        dto.setCustomerCode(exchangeVo.getCustomerCode());
        dto.setFromCode(exchangeVo.getExchangeCode());
        dto.setFromDesc(PoolOperationTypeEnum.RETURNED_GOODS_AMOUNT.getValue());
        dto.setAmount(discountAmount);
        dto.setPoolGroup(PoolGroupEnum.DEFAULT.getDictCode());
        dto.setPayType(PoolPayTypeEnum.DISCOUNT.getDictCode());
        dto.setUseType(com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolUseTypeEnum.DEFAULT.getDictCode());
        dto.setCustomerName(exchangeVo.getCustomerName());
        dto.setOperationType(PoolOperationTypeEnum.RETURNED_GOODS_AMOUNT.getDictCode());
        return dto;
    }

    private CreditPayDto getCreditDto(ExchangeVo exchangeVo, ExchangeDifferenceVo differenceVo) {
        BigDecimal creditAmount = differenceVo.getExchangeAmount();
        CreditPayDto dto = new CreditPayDto();
        dto.setPoolType(CreditPoolTypeEnum.CREDIT.getKey());
        dto.setCustomerCode(exchangeVo.getCustomerCode());
        dto.setFromCode(exchangeVo.getOriginalOrderCode());
        dto.setFromDesc(CashAdjustOperateEnum.RETURN_ORDER.getValue());
        dto.setAmount(creditAmount);
        dto.setAdjustTypeCode(CashAdjustTypeEnum.CREDIT_RELEASE.getDictCode());
        dto.setAdjustOperateCode(CashAdjustOperateEnum.RETURN_ORDER.getDictCode());
        return dto;
    }

    private CostPoolCapitalDto getCapitalDto(ExchangeVo exchangeVo, ExchangeDifferenceVo differenceVo) {
        BigDecimal capitalAmount = differenceVo.getExchangeAmount();
        CostPoolCapitalDto dto = new CostPoolCapitalDto();
        dto.setPoolType(PoolTypeEnum.CAPITAL.getKey());
        dto.setCustomerCode(exchangeVo.getCustomerCode());
        dto.setFromCode(exchangeVo.getExchangeCode());
        dto.setFromDesc(CapitalAdjustTypeEnum.MANUAL_ACCOUNT.getValue());
        dto.setAmount(capitalAmount);
        dto.setAdjustMoney(capitalAmount);
        dto.setAdjustType(CapitalAdjustTypeEnum.RETURNED_GOODS_AMOUNT.getKey());
        dto.setAdjustTypeName(CapitalAdjustTypeEnum.RETURNED_GOODS_AMOUNT.getValue());
        dto.setBillNo(exchangeVo.getExchangeCode());
        dto.setBillType("exchange");
        return dto;
    }
}

