/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.exchange.local.service.helper;

import com.biz.crm.dms.business.returned.goods.sdk.enums.goods.ReturnedGoodsStatusEnum;
import com.biz.crm.dms.business.returned.goods.sdk.service.goods.ReturnedGoodsVoService;
import com.biz.crm.dms.business.returned.goods.sdk.vo.goods.ReturnedGoodsVo;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ReturnGoodsHelper {
    @Autowired(required=false)
    private ReturnedGoodsVoService returnedGoodsVoService;

    public BigDecimal getReturnedAmount(String orderCode, String returnedGoodsCode) {
        List returnedGoodsVoList = this.returnedGoodsVoService.findByOrderCode(orderCode);
        if (CollectionUtils.isEmpty((Collection)returnedGoodsVoList)) {
            return BigDecimal.ZERO;
        }
        returnedGoodsVoList = returnedGoodsVoList.stream().filter(e -> e.getReturnedGoodsStatus().equals(ReturnedGoodsStatusEnum.UNDER_REVIEW.getDictCode()) && e.getReturnedGoodsStatus().equals(ReturnedGoodsStatusEnum.PENDING_STOCK.getDictCode()) && e.getReturnedGoodsStatus().equals(ReturnedGoodsStatusEnum.PART_STOCK.getDictCode()) && e.getReturnedGoodsStatus().equals(ReturnedGoodsStatusEnum.COMPLETELY_STOCK.getDictCode())).collect(Collectors.toList());
        return returnedGoodsVoList.stream().filter(e -> !e.getReturnedGoodsCode().equals(returnedGoodsCode)).map(ReturnedGoodsVo::getCreditAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}

