/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.exchange.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.exchange.local.entity.ExchangeDifferenceEntity;
import com.biz.crm.dms.business.exchange.local.repository.ExchangeDifferenceRepository;
import com.biz.crm.dms.business.exchange.sdk.dto.ExchangeDifferenceDto;
import com.biz.crm.dms.business.exchange.sdk.enums.OperationGuideEnum;
import com.biz.crm.dms.business.exchange.sdk.service.ExchangeDifferenceVoService;
import com.biz.crm.dms.business.exchange.sdk.vo.ExchangeDifferenceVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExchangeDifferenceVoServiceImpl
implements ExchangeDifferenceVoService {
    private static final Logger log = LoggerFactory.getLogger(ExchangeDifferenceVoServiceImpl.class);
    @Autowired(required=false)
    private ExchangeDifferenceRepository exchangeDifferenceRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public List<ExchangeDifferenceVo> findByExchangeCode(String exchangeCodes) {
        if (StringUtils.isBlank((CharSequence)exchangeCodes)) {
            return null;
        }
        List<ExchangeDifferenceEntity> entities = this.exchangeDifferenceRepository.findByExchangeCode(exchangeCodes);
        if (CollectionUtils.isEmpty(entities)) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, ExchangeDifferenceEntity.class, ExchangeDifferenceVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public void createBatch(String exchangeCode, List<ExchangeDifferenceDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        this.exchangeDifferenceRepository.removeByExchangeCodes(Collections.singletonList(exchangeCode));
        dtoList.forEach(dto -> {
            dto.setTenantCode(TenantUtils.getTenantCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto.setExchangeCode(exchangeCode);
            this.createValidation((ExchangeDifferenceDto)dto);
        });
        List entities = (List)this.nebulaToolkitService.copyCollectionByWhiteList(dtoList, ExchangeDifferenceDto.class, ExchangeDifferenceEntity.class, HashSet.class, ArrayList.class, new String[0]);
        this.exchangeDifferenceRepository.saveBatch(entities);
    }

    @Transactional
    public void updateBatch(List<ExchangeDifferenceDto> dtoList) {
        Validate.notEmpty(dtoList, (String)"\u6362\u8d27\u5355\u5dee\u989d\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ArrayList differenceEntities = new ArrayList();
        dtoList.forEach(dto -> {
            this.updateValidation((ExchangeDifferenceDto)dto);
            ExchangeDifferenceEntity entity = (ExchangeDifferenceEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(dto, ExchangeDifferenceEntity.class, HashSet.class, ArrayList.class, new String[0])));
            differenceEntities.add(entity);
        });
        List<String> exchangeCodes = dtoList.stream().map(ExchangeDifferenceDto::getExchangeCode).distinct().collect(Collectors.toList());
        this.exchangeDifferenceRepository.removeByExchangeCodes(exchangeCodes);
        this.exchangeDifferenceRepository.saveBatch(differenceEntities);
    }

    private void createValidation(ExchangeDifferenceDto dto) {
        this.validation(dto);
    }

    private void updateValidation(ExchangeDifferenceDto dto) {
        this.validation(dto);
        Validate.notBlank((CharSequence)dto.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void validation(ExchangeDifferenceDto dto) {
        Validate.notNull((Object)dto, (String)"\u6362\u8d27\u5355\u5dee\u989d\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getExchangeCode(), (String)"\u6362\u8d27\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getExchangeAmount(), (String)"\u5dee\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getPoolType(), (String)"\u6c60\u5b50\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (BigDecimal.ZERO.compareTo(dto.getExchangeAmount()) > 0) {
            dto.setPoolGuide(OperationGuideEnum.USE.getDictCode());
        } else if (BigDecimal.ZERO.compareTo(dto.getExchangeAmount()) < 0) {
            dto.setPoolGuide(OperationGuideEnum.ON.getDictCode());
        }
    }
}

