/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.exchange.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.exchange.local.entity.ExchangeFileEntity;
import com.biz.crm.dms.business.exchange.local.repository.ExchangeFileRepository;
import com.biz.crm.dms.business.exchange.sdk.dto.ExchangeFileDto;
import com.biz.crm.dms.business.exchange.sdk.service.ExchangeFileVoService;
import com.biz.crm.dms.business.exchange.sdk.vo.ExchangeFileVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExchangeFileVoServiceImpl
implements ExchangeFileVoService {
    private static final Logger log = LoggerFactory.getLogger(ExchangeFileVoServiceImpl.class);
    @Autowired(required=false)
    private ExchangeFileRepository exchangeFileRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public List<ExchangeFileVo> findByExchangeCode(String exchangeCodes) {
        if (StringUtils.isBlank((CharSequence)exchangeCodes)) {
            return null;
        }
        List<ExchangeFileEntity> entities = this.exchangeFileRepository.findByExchangeCode(exchangeCodes);
        if (CollectionUtils.isEmpty(entities)) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, ExchangeFileEntity.class, ExchangeFileVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public void createBatch(String exchangeCode, List<ExchangeFileDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        this.exchangeFileRepository.removeByExchangeCodes(Collections.singletonList(exchangeCode));
        dtoList.forEach(dto -> {
            dto.setTenantCode(TenantUtils.getTenantCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto.setExchangeCode(exchangeCode);
            this.createValidation((ExchangeFileDto)dto);
        });
        List entities = (List)this.nebulaToolkitService.copyCollectionByWhiteList(dtoList, ExchangeFileDto.class, ExchangeFileEntity.class, HashSet.class, ArrayList.class, new String[0]);
        this.exchangeFileRepository.saveBatch(entities);
    }

    @Transactional
    public void updateBatch(List<ExchangeFileDto> dtoList) {
        Validate.notEmpty(dtoList, (String)"\u6362\u8d27\u5355\u9644\u4ef6\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ArrayList differenceEntities = new ArrayList();
        dtoList.forEach(dto -> {
            this.updateValidation((ExchangeFileDto)dto);
            ExchangeFileEntity entity = (ExchangeFileEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(dto, ExchangeFileEntity.class, HashSet.class, ArrayList.class, new String[0])));
            differenceEntities.add(entity);
        });
        List<String> exchangeCodes = dtoList.stream().map(ExchangeFileDto::getExchangeCode).distinct().collect(Collectors.toList());
        this.exchangeFileRepository.removeByExchangeCodes(exchangeCodes);
        this.exchangeFileRepository.saveBatch(differenceEntities);
    }

    private void createValidation(ExchangeFileDto dto) {
        this.validation(dto);
    }

    private void updateValidation(ExchangeFileDto dto) {
        this.validation(dto);
        Validate.notBlank((CharSequence)dto.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void validation(ExchangeFileDto dto) {
        Validate.notNull((Object)dto, (String)"user\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

