/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.exchange.local.service.internal;

import com.biz.crm.dms.business.exchange.local.service.helper.OrderHelper;
import com.biz.crm.dms.business.exchange.sdk.dto.ExchangeDto;
import com.biz.crm.dms.business.exchange.sdk.dto.ExchangeFileDto;
import com.biz.crm.dms.business.exchange.sdk.enums.ExchangeStatusEnum;
import com.biz.crm.dms.business.exchange.sdk.service.ExchangeFlowService;
import com.biz.crm.dms.business.exchange.sdk.service.ExchangeVoService;
import com.biz.crm.dms.business.exchange.sdk.vo.ExchangeVo;
import com.biz.crm.dms.business.order.sdk.service.OrderVoService;
import com.biz.crm.dms.business.order.sdk.vo.OrderVo;
import com.biz.crm.workflow.sdk.dto.StartProcessDto;
import com.biz.crm.workflow.sdk.listener.ProcessListener;
import com.biz.crm.workflow.sdk.vo.AttachmentVo;
import com.biz.crm.workflow.sdk.vo.response.CommitWorkflowResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExchangeFlowServiceImpl
implements ExchangeFlowService {
    private static final Logger log = LoggerFactory.getLogger(ExchangeFlowServiceImpl.class);
    @Autowired(required=false)
    private ExchangeVoService exchangeVoService;
    @Autowired(required=false)
    private OrderHelper orderHelper;
    @Autowired(required=false)
    private OrderVoService orderVoService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Transactional
    public void submit(ExchangeDto dto) {
        ExchangeVo exchangeVo = this.exchangeVoService.createOrUpdate(dto);
        Validate.notBlank((CharSequence)dto.getProduceOrderId(), (String)"\u63d0\u4ea4\u6362\u8d27\u5355\u65f6\uff0c\u8ba2\u5355\u672a\u521b\u5efa\u6210\u529f", (Object[])new Object[0]);
        OrderVo orderVo = this.orderVoService.findById(dto.getProduceOrderId());
        Validate.notNull((Object)orderVo, (String)"\u63d0\u4ea4\u6362\u8d27\u5355\u65f6\uff0c\u8ba2\u5355\u672a\u521b\u5efa\u6210\u529f", (Object[])new Object[0]);
        this.orderHelper.occupyExchange(exchangeVo);
        this.commitProcess(dto);
    }

    private void commitValidation(ExchangeDto dto) {
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u6362\u8d27\u5355ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProcessKey(), (String)"\u5ba1\u6279\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getExchangeCode(), (String)"\u6362\u8d27\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCompetenceCode(), (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    public void commitProcess(ExchangeDto dto) {
        this.commitValidation(dto);
        StartProcessDto start = new StartProcessDto();
        start.setBusinessId(dto.getId());
        start.setProcessKey(dto.getProcessKey());
        start.setBusinessNo(dto.getExchangeCode());
        start.setRemark(dto.getProcessRemark());
        start.setMenuCode(dto.getCompetenceCode());
        start.setFormType("exchange");
        start.setProcessTitle(StringUtils.join((Object[])new String[]{"\u6362\u8d27\u5355\u5ba1\u6279", "\uff1a", dto.getExchangeCode()}));
        if (CollectionUtils.isNotEmpty((Collection)dto.getFileList())) {
            List attachmentVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getFileList(), ExchangeFileDto.class, AttachmentVo.class, HashSet.class, ArrayList.class, new String[0]);
            start.setAttachmentVos(attachmentVos);
        }
        HashMap map = Maps.newHashMap();
        map.put("customer_code", dto.getCustomerCode());
        start.setVariables((Map)map);
        SerializableBiConsumer & Serializable sf = ProcessListener::onStartProcess;
        CommitWorkflowResponse response = (CommitWorkflowResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)start, ProcessListener.class, (SerializableBiConsumer)sf);
        Validate.notNull((Object)response, (String)"\u5728\u53d1\u8d77\u8ba2\u5355\u5de5\u4f5c\u6d41\u65f6\uff0c\u6ca1\u6709\u53d1\u73b0\u4e8b\u4ef6\u76d1\u542c\u5b9e\u73b0", (Object[])new Object[0]);
        if (!StringUtils.isNotEmpty((CharSequence)response.getProcessInstanceId())) {
            throw new RuntimeException("\u53d1\u8d77\u6d41\u7a0b\u5931\u8d25\uff01");
        }
        this.exchangeVoService.updateOrderStatusAndProcessNumberById(ExchangeStatusEnum.AWAIT_APPROVE.getDictCode(), response.getProcessInstanceId(), dto.getId());
    }
}

