/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.exchange.local.service.notifier;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.dms.business.exchange.local.service.helper.ExchangeHelper;
import com.biz.crm.dms.business.exchange.local.service.helper.OrderHelper;
import com.biz.crm.dms.business.exchange.sdk.enums.ExchangeStatusEnum;
import com.biz.crm.dms.business.exchange.sdk.service.ExchangeVoService;
import com.biz.crm.dms.business.exchange.sdk.vo.ExchangeVo;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderStatusEnum;
import com.biz.crm.dms.business.order.sdk.service.OrderVoService;
import com.biz.crm.dms.business.order.sdk.vo.OrderVo;
import com.biz.crm.dms.business.returned.goods.sdk.enums.goods.ReturnedGoodsStatusEnum;
import com.biz.crm.dms.business.returned.goods.sdk.service.goods.ReturnedGoodsVoService;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.biz.crm.workflow.sdk.dto.CallBackDto;
import com.biz.crm.workflow.sdk.listener.CallBackListener;
import java.util.HashMap;
import java.util.Objects;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExchangeFlowCallBackImpl
implements CallBackListener {
    @Autowired(required=false)
    private ExchangeVoService exchangeVoService;
    @Autowired(required=false)
    private OrderHelper orderHelper;
    @Autowired(required=false)
    private ExchangeHelper exchangeHelper;
    @Autowired(required=false)
    private OrderVoService orderVoService;
    @Autowired(required=false)
    private ReturnedGoodsVoService returnedGoodsVoService;

    @Transactional
    public void onCallBack(CallBackDto dto) {
        if (!dto.getFormType().equals("exchange")) {
            return;
        }
        String formNo = dto.getFormNo();
        ExchangeVo exchangeVo = this.exchangeVoService.findByExchangeCode(formNo);
        if (Objects.isNull(exchangeVo)) {
            return;
        }
        String exchangeStatus = exchangeVo.getExchangeStatus();
        String awaitApprove = ExchangeStatusEnum.AWAIT_APPROVE.getDictCode();
        boolean equals = awaitApprove.equals(exchangeStatus);
        Validate.isTrue((boolean)equals, (String)"\u6b64\u6362\u8d27\u5355\u975e\u5ba1\u6279\u4e2d\u72b6\u6001\uff0c\u65e0\u6cd5\u63a5\u53d7\u5de5\u4f5c\u6d41\u7684\u64cd\u4f5c\uff01", (Object[])new Object[0]);
        Integer processState = dto.getProcessState();
        exchangeStatus = this.getExchangeStatus(processState);
        this.exchangeVoService.updateExchangeStatusById(exchangeStatus, exchangeVo.getId());
        OrderVo orderVo = this.orderVoService.findById(exchangeVo.getProduceOrderId());
        Validate.notNull((Object)orderVo, (String)"\u5ba1\u6279\u65f6\u672a\u83b7\u53d6\u5230\u8ba2\u5355\u4fe1\u606f\uff01", (Object[])new Object[0]);
        boolean isCompleted = ExchangeStatusEnum.COMPLETED.getDictCode().equals(exchangeStatus);
        if (isCompleted) {
            this.orderHelper.paymentExchange(exchangeVo);
            this.exchangeHelper.upAccount(exchangeVo);
            this.orderVoService.updateOrderStatusAndIsShowByOrderCode(exchangeVo.getProduceOrderCode(), OrderStatusEnum.WAIT_SHIPPED, Boolean.TRUE);
            this.returnedGoodsVoService.updateStatusAndIsShowByReturnedGoodsCode(exchangeVo.getProduceReturnCode(), ReturnedGoodsStatusEnum.PENDING_STOCK, BooleanEnum.TRUE);
            return;
        }
        this.orderHelper.releaseExchange(exchangeVo);
        this.orderHelper.releaseSalePolicy(orderVo);
        this.orderHelper.returnStock(orderVo);
        ReturnedGoodsStatusEnum returnedGoodsStatusEnum = ReturnedGoodsStatusEnum.REJECTED;
        OrderStatusEnum orderStatusEnum = OrderStatusEnum.REJECTED;
        if (ActApproveStatusEnum.INTERRUPT.getCode().equals(processState.toString())) {
            returnedGoodsStatusEnum = ReturnedGoodsStatusEnum.RECALL;
            orderStatusEnum = OrderStatusEnum.CANCELED;
        }
        this.returnedGoodsVoService.updateStatusAndIsShowByReturnedGoodsCode(exchangeVo.getProduceReturnCode(), returnedGoodsStatusEnum, BooleanEnum.FALSE);
        this.orderVoService.updateOrderStatusAndIsShowByOrderCode(exchangeVo.getProduceOrderCode(), orderStatusEnum, Boolean.FALSE);
    }

    private String getExchangeStatus(Integer processState) {
        HashMap<String, String> map = new HashMap<String, String>(ActApproveStatusEnum.values().length);
        map.put(ActApproveStatusEnum.APPROVED.getCode(), ExchangeStatusEnum.COMPLETED.getDictCode());
        map.put(ActApproveStatusEnum.REJECTED.getCode(), ExchangeStatusEnum.REJECTED.getDictCode());
        map.put(ActApproveStatusEnum.INTERRUPT.getCode(), ExchangeStatusEnum.CANCELED.getDictCode());
        return (String)map.get(processState.toString());
    }
}

