/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.exchange.local.strategy;

import com.biz.crm.dms.business.exchange.sdk.dto.ExchangeDto;
import com.biz.crm.dms.business.exchange.sdk.strategy.ExchangeVerificationStrategy;
import com.biz.crm.dms.business.returned.goods.sdk.dto.goods.ReturnedGoodsDto;
import java.math.BigDecimal;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RefundAmountVerificationStrategyImpl
implements ExchangeVerificationStrategy {
    private static final Logger log = LoggerFactory.getLogger(RefundAmountVerificationStrategyImpl.class);

    public void execute(ExchangeDto exchangeDto) {
        Validate.notNull((Object)exchangeDto.getReturnedGoods(), (String)"\u9000\u8d27\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ReturnedGoodsDto returnedGoodsDto = exchangeDto.getReturnedGoods();
        BigDecimal totalAmount = returnedGoodsDto.getTotalAmount();
        Validate.notNull((Object)totalAmount, (String)"\u9000\u8d27\u603b\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        BigDecimal creditAmount = Objects.isNull(returnedGoodsDto.getCreditAmount()) ? BigDecimal.ZERO : returnedGoodsDto.getCreditAmount();
        BigDecimal capitalAmount = Objects.isNull(returnedGoodsDto.getCapitalAmount()) ? BigDecimal.ZERO : returnedGoodsDto.getCapitalAmount();
        BigDecimal policyAmount = Objects.isNull(returnedGoodsDto.getPolicyAmount()) ? BigDecimal.ZERO : returnedGoodsDto.getPolicyAmount();
        BigDecimal discountAmount = Objects.isNull(returnedGoodsDto.getDiscountAmount()) ? BigDecimal.ZERO : returnedGoodsDto.getDiscountAmount();
        BigDecimal replenishmentAmount = Objects.isNull(returnedGoodsDto.getReplenishmentAmount()) ? BigDecimal.ZERO : returnedGoodsDto.getReplenishmentAmount();
        Validate.isTrue((totalAmount.compareTo(creditAmount.add(capitalAmount).add(policyAmount).add(discountAmount).add(replenishmentAmount)) == 0 ? 1 : 0) != 0, (String)"\u5fc5\u987b\u6ee1\u8db3\uff1a\u672c\u5355\u9000\u8fd8\u603b\u91d1\u989d=\u672c\u5355\u9000\u8fd8\u6388\u4fe1+\u672c\u5355\u9000\u8fd8\u8d44\u91d1+\u672c\u5355\u9000\u8fd8\u653f\u7b56\u4f18\u60e0\u91d1\u989d+\u672c\u5355\u9000\u8fd8\u6298\u6263\u8d39\u7528+\u672c\u5355\u9000\u6362\u8d27\u8865\u8d39\u7528", (Object[])new Object[0]);
    }

    public int order() {
        return 2;
    }
}

