package com.biz.crm.dms.business.exchange.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.exchange.sdk.service.ExchangeDifferenceVoService;
import com.biz.crm.dms.business.exchange.sdk.vo.ExchangeDifferenceVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * 换货单差额子表(DmsOrderExchangeDifference)表控制层
 *
 * @author xi.peng
 * @since 2022-07-06 19:00:34
 */
@Slf4j
@Api(tags = "换货单差额子表：ExchangeDifferenceVo")
@RestController
@RequestMapping(value = {"/v1/exchange/exchangeDifferenceVo"})
public class ExchangeDifferenceVoController {

  @Autowired
  private ExchangeDifferenceVoService exchangeDifferenceVoService;

  @ApiOperation(value = "根据换货单查询差额信息")
  @GetMapping(value = {"/findByExchangeCode"})
  public Result<List<ExchangeDifferenceVo>> findByExchangeCode(@RequestParam("exchangeCode") String exchangeCode) {
    try {
      List<ExchangeDifferenceVo> voList = this.exchangeDifferenceVoService.findByExchangeCode(exchangeCode);
      return Result.ok(voList);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
