package com.biz.crm.dms.business.exchange.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.delivery.sdk.dto.DeliveryUnshippedPageDto;
import com.biz.crm.dms.business.exchange.sdk.service.ExchangeableVoService;
import com.biz.crm.dms.business.exchange.sdk.vo.ExchangeableVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 换货单资源类业务控制层
 *
 * @author xi.peng
 * @since 2022-07-06 19:00:33
 */
@Slf4j
@Api(tags = "可换货VO：ExchangeableVo")
@RestController
@RequestMapping(value = {"/v1/exchange/exchangeableVo"})
public class ExchangeableVoController {

  @Autowired
  private ExchangeableVoService exchangeableVoService;

  /**
   * 查询可换货订单信息
   */
  @ApiOperation(value = "查询可换货订单信息")
  @GetMapping("findExchangeablePage")
  public Result<Page<ExchangeableVo>> findExchangeablePage(@PageableDefault(50) Pageable pageable, @ApiParam(name = "order", value = "根据订单状态查询订单信息分页接口") DeliveryUnshippedPageDto dto) {
    try {
      Validate.notEmpty(dto.getOrderStatus(), "订单状态条件必传！");
      Page<ExchangeableVo> result = this.exchangeableVoService.findByOrderUnshippedPageDto(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
