package com.biz.crm.dms.business.exchange.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 换货单附件子表(DmsOrderExchangeFile)实体类
 *
 * @author sunx
 * @since 2022-07-06 19:00:33
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@Table(name = "dms_exchange_file")
@TableName(value = "dms_exchange_file")
@ApiModel(value = "DmsExchangeFile", description = "换货单附件子表")
@org.hibernate.annotations.Table(appliesTo = "dms_exchange_file", comment = "换货单附件子表")
public class ExchangeFileEntity extends FileEntity {

  @ApiModelProperty("换货单编码")
  @TableField(value = "exchange_code")
  @Column(name = "exchange_code", length = 64, columnDefinition = "varchar(64) COMMENT '换货单编码'")
  private String exchangeCode;
}
