package com.biz.crm.dms.business.exchange.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.exchange.local.entity.ExchangeEntity;
import com.biz.crm.dms.business.exchange.local.mapper.ExchangeMapper;

import java.util.List;

import com.biz.crm.dms.business.exchange.sdk.dto.ExchangePageDto;
import com.biz.crm.dms.business.exchange.sdk.vo.ExchangeVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;

/**
 * 换货单主表实体(repository)
 *
 * @author xi.peng
 * @since 2022-07-06 19:00:31
 */
@Component
public class ExchangeRepository extends ServiceImpl<ExchangeMapper, ExchangeEntity> {
  
  /**
   * 分页
   *
   * @param page 分页参数
   * @param dto 换货单dto
   * @return Page<DmsOrderExchangeVo>
   */
  public Page<ExchangeVo> findByConditions(Page<ExchangePageDto> page, ExchangePageDto dto) {
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    return baseMapper.findByConditions(page, dto);
  }
  
  /**
   * 根据ID获取详情
   *
   * @param id 换货单ID
   * @return DmsOrderExchangeEntity
   */
  public ExchangeEntity findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids 换货单ID集合
   * @return List<DmsOrderExchangeEntity>
   */
  public List<ExchangeEntity> findByIds(List<String> ids) {
    return this.lambdaQuery()
    .eq(ExchangeEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
    .in(ExchangeEntity::getId, ids).list();
  }

  /**
   * 根据换货单编码查询
   *
   * @param exchangeCode 换货单编码
   * @return DmsOrderExchangeEntity
   */
  public ExchangeEntity findByExchangeCode(String exchangeCode) {
    return this.lambdaQuery()
        .eq(ExchangeEntity::getTenantCode, TenantUtils.getTenantCode())
        .eq(ExchangeEntity::getExchangeCode, exchangeCode)
        .one();
  }


  /**
   * 根据 id 修改 exchangeStatus
   *
   * @param exchangeStatus 换货单状态
   * @param id 换货单ID
   */
  public void updateExchangeStatusById(String exchangeStatus, String id) {
    this.lambdaUpdate()
        .set(ExchangeEntity::getExchangeStatus, exchangeStatus)
        .eq(ExchangeEntity::getId, id)
        .update();
  }


  /**
   * 根据 id 修改 exchangeStatus
   *
   * @param exchangeStatus 换货单状态
   * @param processNumber 审批单号
   * @param id 换货单ID
   */
  public void updateOrderStatusAndProcessNumberById(String exchangeStatus,String processNumber, String id) {
    this.lambdaUpdate()
        .set(ExchangeEntity::getExchangeStatus, exchangeStatus)
        .set(ExchangeEntity::getProcessNumber, processNumber)
        .eq(ExchangeEntity::getId, id)
        .update();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids ID集合
   * @param enable 启禁用状态枚举
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate().in(ExchangeEntity::getId, ids)
        .set(ExchangeEntity::getEnableStatus, enable.getCode()).update();
  }

  /**
   * 逻辑删除
   *
   * @param ids ID集合
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate().in(ExchangeEntity::getId, ids)
        .set(ExchangeEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode()).update();
  }
}
