package com.biz.crm.dms.business.exchange.local.service.helper;

import com.biz.crm.dms.business.returned.goods.sdk.enums.goods.ReturnedGoodsStatusEnum;
import com.biz.crm.dms.business.returned.goods.sdk.service.goods.ReturnedGoodsReplenishmentVoService;
import com.biz.crm.dms.business.returned.goods.sdk.service.goods.ReturnedGoodsVoService;
import com.biz.crm.dms.business.returned.goods.sdk.vo.goods.ReturnedGoodsVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 换货单针对退货业务辅助类
 * - 用与消除冗余代码
 * - 统一部分业务流程
 *
 * @author pengxi
 * @date 2022/7/7
 */
@Component
public class ReturnGoodsHelper {

  @Autowired(required = false)
  private ReturnedGoodsVoService returnedGoodsVoService;

  /**
   * 获取当前订单已退还授信金额
   * @param orderCode 被退货的订单号
   * @param returnedGoodsCode 当前退货单号
   * @return BigDecimal
   */
  public BigDecimal getReturnedAmount(String orderCode, String returnedGoodsCode) {
    List<ReturnedGoodsVo> returnedGoodsVoList = returnedGoodsVoService.findByOrderCode(orderCode);
    if (CollectionUtils.isEmpty(returnedGoodsVoList)) {
      return BigDecimal.ZERO;
    }
    returnedGoodsVoList = returnedGoodsVoList.stream()
        .filter(e-> e.getReturnedGoodsStatus().equals(ReturnedGoodsStatusEnum.UNDER_REVIEW.getDictCode())
                && e.getReturnedGoodsStatus().equals(ReturnedGoodsStatusEnum.PENDING_STOCK.getDictCode())
                && e.getReturnedGoodsStatus().equals(ReturnedGoodsStatusEnum.PART_STOCK.getDictCode())
                && e.getReturnedGoodsStatus().equals(ReturnedGoodsStatusEnum.COMPLETELY_STOCK.getDictCode()))
        .collect(Collectors.toList());
    return returnedGoodsVoList.stream()
        .filter(e->!e.getReturnedGoodsCode().equals(returnedGoodsCode))
        .map(ReturnedGoodsVo::getCreditAmount)
        .reduce(BigDecimal.ZERO, BigDecimal::add);
  }

}
