package com.biz.crm.dms.business.exchange.local.strategy;


import com.biz.crm.dms.business.exchange.sdk.dto.ExchangeDto;
import com.biz.crm.dms.business.exchange.sdk.strategy.ExchangeVerificationStrategy;
import com.biz.crm.dms.business.returned.goods.sdk.dto.goods.ReturnedGoodsDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * 退还金额校验
 * b. 本单退还授信+本单退还资金+本单退还政策优惠金额+本单退还折扣费用+本单退换货补费用=本单退还总金额。
 *
 * @author pengxi
 * @date 2022/7/12
 */
@Slf4j
@Component
public class RefundAmountVerificationStrategyImpl implements ExchangeVerificationStrategy {

  @Override
  public void execute(ExchangeDto exchangeDto) {
    Validate.notNull(exchangeDto.getReturnedGoods(), "退货信息不能为空！");
    ReturnedGoodsDto returnedGoodsDto = exchangeDto.getReturnedGoods();
    BigDecimal totalAmount = returnedGoodsDto.getTotalAmount();
    Validate.notNull(totalAmount, "退货总金额不能为空！");
    BigDecimal creditAmount = Objects.isNull(returnedGoodsDto.getCreditAmount())?BigDecimal.ZERO:returnedGoodsDto.getCreditAmount();
    BigDecimal capitalAmount = Objects.isNull(returnedGoodsDto.getCapitalAmount())?BigDecimal.ZERO:returnedGoodsDto.getCapitalAmount();
    BigDecimal policyAmount = Objects.isNull(returnedGoodsDto.getPolicyAmount())?BigDecimal.ZERO:returnedGoodsDto.getPolicyAmount();
    BigDecimal discountAmount = Objects.isNull(returnedGoodsDto.getDiscountAmount())?BigDecimal.ZERO:returnedGoodsDto.getDiscountAmount();
    BigDecimal replenishmentAmount = Objects.isNull(returnedGoodsDto.getReplenishmentAmount())?BigDecimal.ZERO:returnedGoodsDto.getReplenishmentAmount();
    Validate.isTrue(totalAmount.compareTo(creditAmount.add(capitalAmount).add(policyAmount).add(discountAmount).add(replenishmentAmount)) == 0, "必须满足：本单退还总金额=本单退还授信+本单退还资金+本单退还政策优惠金额+本单退还折扣费用+本单退换货补费用");
  }

  @Override
  public int order() {
    return 2;
  }
}
