/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.exchange.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.exchange.sdk.dto.ExchangeDto;
import com.biz.crm.dms.business.exchange.sdk.dto.ExchangePageDto;
import com.biz.crm.dms.business.exchange.sdk.service.ExchangeVoService;
import com.biz.crm.dms.business.exchange.sdk.vo.ExchangeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6362\u8d27\u5355\u4e3b\u8868\u5b9e\u4f53\uff1aExchangeVo"})
@RestController
@RequestMapping(value={"/v1/exchange/exchangeVo"})
public class ExchangeVoController {
    private static final Logger log = LoggerFactory.getLogger(ExchangeVoController.class);
    @Autowired
    private ExchangeVoService exchangeVoService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<ExchangeVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, ExchangePageDto dto) {
        try {
            Page result = this.exchangeVoService.findByConditions(pageable, dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<ExchangeVo> findDetailById(@RequestParam(value="id") String id) {
        try {
            ExchangeVo vo = this.exchangeVoService.findDetailById(id);
            return Result.ok((Object)vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u7f16\u7801\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/findDetailByCode"})
    public Result<ExchangeVo> findDetailByCode(@RequestParam(value="code") String code) {
        try {
            ExchangeVo vo = this.exchangeVoService.findDetailByCode(code);
            return Result.ok((Object)vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6682\u5b58")
    @PostMapping(value={"draft"})
    public Result draft(@RequestBody ExchangeDto dto) {
        try {
            this.exchangeVoService.draft(dto);
            return Result.ok((String)"\u6682\u5b58\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.exchangeVoService.updateDelFlagByIds(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8ba1\u7b97\u5dee\u989d")
    @PostMapping(value={"difference"})
    public Result<ExchangeVo> difference(@RequestBody ExchangeDto dto) {
        try {
            ExchangeVo exchangeVo = this.exchangeVoService.difference(dto);
            return Result.ok((Object)exchangeVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

