/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.exchange.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.exchange.local.entity.ExchangeEntity;
import com.biz.crm.dms.business.exchange.local.mapper.ExchangeMapper;
import com.biz.crm.dms.business.exchange.sdk.dto.ExchangePageDto;
import com.biz.crm.dms.business.exchange.sdk.vo.ExchangeVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ExchangeRepository
extends ServiceImpl<ExchangeMapper, ExchangeEntity> {
    public Page<ExchangeVo> findByConditions(Page<ExchangePageDto> page, ExchangePageDto dto) {
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return ((ExchangeMapper)this.baseMapper).findByConditions(page, dto);
    }

    public ExchangeEntity findById(String id) {
        return (ExchangeEntity)((Object)((ExchangeMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    public List<ExchangeEntity> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(UuidEntity::getId, ids)).list();
    }

    public ExchangeEntity findByExchangeCode(String exchangeCode) {
        return (ExchangeEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(ExchangeEntity::getExchangeCode, (Object)exchangeCode)).one());
    }

    public void updateExchangeStatusById(String exchangeStatus, String id) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(ExchangeEntity::getExchangeStatus, (Object)exchangeStatus)).eq(UuidEntity::getId, (Object)id)).update();
    }

    public void updateOrderStatusAndProcessNumberById(String exchangeStatus, String processNumber, String id) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(ExchangeEntity::getExchangeStatus, (Object)exchangeStatus)).set(ExchangeEntity::getProcessNumber, (Object)processNumber)).eq(UuidEntity::getId, (Object)id)).update();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).update();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }
}

