/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.exchange.local.service.helper;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CostPoolCapitalDto;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.CapitalAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.PoolTypeEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditPayDto;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustOperateEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CreditPoolTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolGroupEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolPayTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolUseTypeEnum;
import com.biz.crm.dms.business.costpool.sdk.service.CostPoolVoService;
import com.biz.crm.dms.business.exchange.sdk.vo.ExchangeVo;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderCategoryEnum;
import com.biz.crm.dms.business.order.sdk.vo.OrderDetailVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderVo;
import com.biz.crm.dms.business.policy.sdk.service.SalePolicyRecordVoService;
import com.biz.crm.dms.business.psi.product.sdk.dto.productstock.ProductStockOperationDto;
import com.biz.crm.dms.business.psi.product.sdk.enums.productstock.ProductStockOperationType;
import com.biz.crm.dms.business.psi.product.sdk.service.productstock.ProductStockVoService;
import com.biz.crm.mdm.business.warehouse.sdk.service.WarehouseVoService;
import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OrderHelper {
    @Autowired(required=false)
    private CostPoolVoService costPoolVoService;
    @Autowired(required=false)
    private ProductStockVoService productStockVoService;
    @Autowired(required=false)
    private SalePolicyRecordVoService salePolicyRecordVoService;
    @Autowired(required=false)
    private WarehouseVoService warehouseVoService;

    public void returnStock(OrderVo orderVo) {
        WarehouseVo warehouse = this.findWarehouseVo(orderVo);
        Validate.notNull((Object)warehouse, (String)"\u6362\u8d27\u5355\u5360\u7528\u5e93\u5b58\u7684\u65f6\u5019\uff0c\u6ca1\u6709\u627e\u5230\u4ed3\u5e93\u4fe1\u606f", (Object[])new Object[0]);
        List<ProductStockOperationDto> list = this.getProductStockOperationDtos(orderVo, warehouse);
        this.productStockVoService.thawBatch(list);
    }

    public void releaseSalePolicy(OrderVo orderVo) {
        this.salePolicyRecordVoService.deleteByBillCode(orderVo.getOrderCode(), orderVo.getTenantCode(), orderVo.getRelateCode());
    }

    public void paymentExchange(ExchangeVo exchangeVo) {
        this.releaseExchange(exchangeVo);
        this.useExchange(exchangeVo);
    }

    public void useExchange(ExchangeVo exchangeVo) {
        List differenceVoList = exchangeVo.getDifferenceList();
        if (CollectionUtils.isEmpty((Collection)differenceVoList)) {
            return;
        }
        JSONArray array = new JSONArray();
        differenceVoList.forEach(diff -> {
            if (BigDecimal.ZERO.compareTo(diff.getExchangeAmount()) < 1) {
                return;
            }
            if (CreditPoolTypeEnum.CREDIT.getDictCode().equals(diff.getPoolType())) {
                CreditPayDto creditPayDto = OrderHelper.getCreditPayDto(exchangeVo, diff.getExchangeAmount().abs(), CashAdjustOperateEnum.ORDER, CashAdjustTypeEnum.CREDIT_REDUCE);
                array.add((Object)creditPayDto);
            }
            if (PoolTypeEnum.CAPITAL.getDictCode().equals(diff.getPoolType())) {
                CostPoolCapitalDto costPoolCapitalDto = OrderHelper.getCostPoolCapitalDto(exchangeVo, diff.getExchangeAmount().abs(), CapitalAdjustTypeEnum.ORDER_USE);
                array.add((Object)costPoolCapitalDto);
            }
            if (com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolTypeEnum.DISCOUNT.getDictCode().equals(diff.getPoolType())) {
                CostPoolDiscountDto discountDto = OrderHelper.getCostPoolDiscountDto(exchangeVo, diff.getExchangeAmount().abs(), PoolOperationTypeEnum.ORDER_USE);
                array.add((Object)discountDto);
            }
            if (com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolTypeEnum.Replenishment.getDictCode().equals(diff.getPoolType())) {
                CostPoolReplenishmentDto replenishmentDto = OrderHelper.getCostPoolReplenishmentDto(exchangeVo, diff.getSourceCode(), diff.getExchangeAmount().abs(), com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeEnum.ORDER_USE);
                array.add((Object)replenishmentDto);
            }
        });
        if (CollectionUtils.isEmpty((Collection)array)) {
            return;
        }
        this.costPoolVoService.handleAdjust(array);
    }

    public void releaseExchange(ExchangeVo exchangeVo) {
        List differenceVoList = exchangeVo.getDifferenceList();
        if (CollectionUtils.isEmpty((Collection)differenceVoList)) {
            return;
        }
        JSONArray array = new JSONArray();
        differenceVoList.forEach(diff -> {
            if (BigDecimal.ZERO.compareTo(diff.getExchangeAmount()) < 1) {
                return;
            }
            if (CreditPoolTypeEnum.CREDIT.getDictCode().equals(diff.getPoolType())) {
                CreditPayDto creditPayDto = OrderHelper.getCreditPayDto(exchangeVo, diff.getExchangeAmount().abs(), CashAdjustOperateEnum.OCCUPY_RELEASE, CashAdjustTypeEnum.OCCUPY_RELEASE);
                array.add((Object)creditPayDto);
            }
            if (PoolTypeEnum.CAPITAL.getDictCode().equals(diff.getPoolType())) {
                CostPoolCapitalDto costPoolCapitalDto = OrderHelper.getCostPoolCapitalDto(exchangeVo, diff.getExchangeAmount().abs(), CapitalAdjustTypeEnum.OCCUPY_RELEASE);
                array.add((Object)costPoolCapitalDto);
            }
            if (com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolTypeEnum.DISCOUNT.getDictCode().equals(diff.getPoolType())) {
                CostPoolDiscountDto discountDto = OrderHelper.getCostPoolDiscountDto(exchangeVo, diff.getExchangeAmount().abs(), PoolOperationTypeEnum.OCCUPY_RELEASE);
                array.add((Object)discountDto);
            }
            if (com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolTypeEnum.Replenishment.getDictCode().equals(diff.getPoolType())) {
                CostPoolReplenishmentDto replenishmentDto = OrderHelper.getCostPoolReplenishmentDto(exchangeVo, diff.getSourceCode(), diff.getExchangeAmount().abs(), com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeEnum.OCCUPY_RELEASE);
                array.add((Object)replenishmentDto);
            }
        });
        if (CollectionUtils.isEmpty((Collection)array)) {
            return;
        }
        this.costPoolVoService.handleAdjust(array);
    }

    public void occupyExchange(ExchangeVo exchangeVo) {
        List differenceVoList = exchangeVo.getDifferenceList();
        if (CollectionUtils.isEmpty((Collection)differenceVoList)) {
            return;
        }
        JSONArray array = new JSONArray();
        differenceVoList.forEach(diff -> {
            if (BigDecimal.ZERO.compareTo(diff.getExchangeAmount()) < 1) {
                return;
            }
            if (CreditPoolTypeEnum.CREDIT.getDictCode().equals(diff.getPoolType())) {
                CreditPayDto creditPayDto = OrderHelper.getCreditPayDto(exchangeVo, diff.getExchangeAmount().abs(), CashAdjustOperateEnum.OCCUPY_USE, CashAdjustTypeEnum.OCCUPY_USE);
                array.add((Object)creditPayDto);
            }
            if (PoolTypeEnum.CAPITAL.getDictCode().equals(diff.getPoolType())) {
                CostPoolCapitalDto costPoolCapitalDto = OrderHelper.getCostPoolCapitalDto(exchangeVo, diff.getExchangeAmount().abs(), CapitalAdjustTypeEnum.OCCUPY_USE);
                array.add((Object)costPoolCapitalDto);
            }
            if (com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolTypeEnum.DISCOUNT.getDictCode().equals(diff.getPoolType())) {
                CostPoolDiscountDto discountDto = OrderHelper.getCostPoolDiscountDto(exchangeVo, diff.getExchangeAmount().abs(), PoolOperationTypeEnum.OCCUPY_USE);
                array.add((Object)discountDto);
            }
            if (com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolTypeEnum.Replenishment.getDictCode().equals(diff.getPoolType())) {
                CostPoolReplenishmentDto replenishmentDto = OrderHelper.getCostPoolReplenishmentDto(exchangeVo, diff.getSourceCode(), diff.getExchangeAmount().abs(), com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeEnum.OCCUPY_USE);
                array.add((Object)replenishmentDto);
            }
        });
        if (CollectionUtils.isEmpty((Collection)array)) {
            return;
        }
        this.costPoolVoService.handleAdjust(array);
    }

    public void occupyStock(OrderVo orderVo) {
        WarehouseVo warehouse = this.findWarehouseVo(orderVo);
        Validate.notNull((Object)warehouse, (String)"\u8ba2\u5355\u5360\u7528\u5e93\u5b58\u7684\u65f6\u5019\uff0c\u6ca1\u6709\u627e\u5230\u4ed3\u5e93\u4fe1\u606f", (Object[])new Object[0]);
        List<ProductStockOperationDto> list = this.getProductStockOperationDtos(orderVo, warehouse);
        this.productStockVoService.frozenBatch(list);
    }

    private WarehouseVo findWarehouseVo(OrderVo orderVo) {
        WarehouseVo warehouse = null;
        if (orderVo.getOrderCategory().equals(OrderCategoryEnum.MATERIAL_ORDER.getDictCode())) {
            String warehouseCode = orderVo.getWarehouseCode();
            warehouse = this.warehouseVoService.findDetailsByCode(warehouseCode);
        } else {
            warehouse = this.warehouseVoService.findDetailsByCityCode(orderVo.getCityCode());
            if (warehouse == null) {
                warehouse = this.warehouseVoService.findDetailsByWarehouseDefault(Boolean.valueOf(true));
            }
        }
        return warehouse;
    }

    private List<ProductStockOperationDto> getProductStockOperationDtos(OrderVo order, WarehouseVo warehouse) {
        List orderDetails = order.getOrderDetails();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)orderDetails) ? 1 : 0) != 0, (String)"\u8ba2\u5355\u5360\u7528\u5e93\u5b58\u7684\u65f6\u5019\uff0c\u6ca1\u6709\u8d27\u7269\u4fe1\u606f", (Object[])new Object[0]);
        ArrayList list = Lists.newArrayListWithCapacity((int)orderDetails.size());
        for (OrderDetailVo orderDetail : orderDetails) {
            ProductStockOperationDto productStockOperationDto = new ProductStockOperationDto();
            productStockOperationDto.setWarehouseCode(warehouse.getWarehouseCode());
            productStockOperationDto.setWarehouseName(warehouse.getWarehouseName());
            productStockOperationDto.setProductCode(orderDetail.getGoodsCode());
            productStockOperationDto.setProductName(orderDetail.getGoodsName());
            productStockOperationDto.setProductStockOperationType(ProductStockOperationType.SALE_DELIVER.getDictCode());
            productStockOperationDto.setCustomerCode(order.getRelateCode());
            productStockOperationDto.setCustomerName(order.getRelateName());
            productStockOperationDto.setOriginalOrderCode(order.getOriginalOrderCode());
            productStockOperationDto.setOrderType(order.getOrderType());
            productStockOperationDto.setOrderCode(order.getOrderCode());
            productStockOperationDto.setOrderItemCode(orderDetail.getOrderDetailCode());
            productStockOperationDto.setQuantity(orderDetail.getQuantity());
            list.add(productStockOperationDto);
        }
        return list;
    }

    private static CostPoolCapitalDto getCostPoolCapitalDto(ExchangeVo exchangeVo, BigDecimal itemAmount, CapitalAdjustTypeEnum capitalAdjustTypeEnum) {
        CostPoolCapitalDto dto = new CostPoolCapitalDto();
        dto.setPoolType(PoolTypeEnum.CAPITAL.getKey());
        dto.setCustomerCode(exchangeVo.getCustomerCode());
        dto.setFromCode(exchangeVo.getExchangeCode());
        dto.setFromDesc(capitalAdjustTypeEnum.getValue());
        dto.setAmount(itemAmount);
        dto.setAdjustMoney(itemAmount);
        dto.setAdjustType(capitalAdjustTypeEnum.getKey());
        dto.setAdjustTypeName(capitalAdjustTypeEnum.getValue());
        dto.setBillNo(exchangeVo.getExchangeCode());
        dto.setBillType(exchangeVo.getExchangeType());
        return dto;
    }

    private static CreditPayDto getCreditPayDto(ExchangeVo exchangeVo, BigDecimal itemAmount, CashAdjustOperateEnum cashAdjustOperateEnum, CashAdjustTypeEnum cashAdjustTypeEnum) {
        CreditPayDto dto = new CreditPayDto();
        dto.setPoolType(CreditPoolTypeEnum.CREDIT.getKey());
        dto.setCustomerCode(exchangeVo.getCustomerCode());
        dto.setFromCode(exchangeVo.getExchangeCode());
        dto.setFromDesc(cashAdjustOperateEnum.getValue());
        dto.setAmount(itemAmount);
        dto.setAdjustTypeCode(cashAdjustTypeEnum.getDictCode());
        dto.setAdjustOperateCode(cashAdjustOperateEnum.getDictCode());
        return dto;
    }

    private static CostPoolDiscountDto getCostPoolDiscountDto(ExchangeVo exchangeVo, BigDecimal itemAmount, PoolOperationTypeEnum poolOperationTypeEnum) {
        CostPoolDiscountDto dto = new CostPoolDiscountDto();
        dto.setPoolType(com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolTypeEnum.DISCOUNT.getKey());
        dto.setCustomerCode(exchangeVo.getCustomerCode());
        dto.setCustomerName(exchangeVo.getCustomerName());
        dto.setFromCode(exchangeVo.getExchangeCode());
        dto.setFromDesc(poolOperationTypeEnum.getValue());
        dto.setAmount(itemAmount);
        dto.setPoolGroup(PoolGroupEnum.DEFAULT.getDictCode());
        dto.setPayType(PoolPayTypeEnum.DISCOUNT.getDictCode());
        dto.setUseType(com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolUseTypeEnum.DEFAULT.getDictCode());
        dto.setOperationType(poolOperationTypeEnum.getDictCode());
        return dto;
    }

    private static CostPoolReplenishmentDto getCostPoolReplenishmentDto(ExchangeVo exchangeVo, String poolCode, BigDecimal salesAmount, com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolOperationTypeEnum poolOperationTypeEnum) {
        CostPoolReplenishmentDto dto = new CostPoolReplenishmentDto();
        dto.setPoolType(com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolTypeEnum.Replenishment.getKey());
        dto.setCustomerCode(exchangeVo.getCustomerCode());
        dto.setCustomerName(exchangeVo.getCustomerName());
        dto.setFromCode(exchangeVo.getExchangeCode());
        dto.setFromDesc(poolOperationTypeEnum.getValue());
        dto.setAmount(salesAmount);
        dto.setPoolCode(poolCode);
        dto.setPoolGroup(com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolGroupEnum.DEFAULT.getDictCode());
        dto.setPayType(com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolPayTypeEnum.Replenishment.getDictCode());
        dto.setUseType(PoolUseTypeEnum.DEFAULT.getDictCode());
        dto.setOperationType(poolOperationTypeEnum.getDictCode());
        return dto;
    }
}

