/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.exchange.local.service.internal;

import com.biz.crm.dms.business.exchange.local.service.helper.OrderHelper;
import com.biz.crm.dms.business.exchange.sdk.dto.ExchangeDto;
import com.biz.crm.dms.business.exchange.sdk.enums.ExchangeStatusEnum;
import com.biz.crm.dms.business.exchange.sdk.service.ExchangeFlowService;
import com.biz.crm.dms.business.exchange.sdk.service.ExchangeVoService;
import com.biz.crm.dms.business.exchange.sdk.vo.ExchangeVo;
import com.biz.crm.dms.business.order.sdk.service.OrderVoService;
import com.biz.crm.dms.business.order.sdk.vo.OrderVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExchangeFlowServiceImpl
implements ExchangeFlowService {
    private static final Logger log = LoggerFactory.getLogger(ExchangeFlowServiceImpl.class);
    @Autowired(required=false)
    private ExchangeVoService exchangeVoService;
    @Autowired(required=false)
    private OrderHelper orderHelper;
    @Autowired(required=false)
    private OrderVoService orderVoService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;

    @Transactional
    public void submit(ExchangeDto dto) {
        ExchangeVo exchangeVo = this.exchangeVoService.createOrUpdate(dto);
        Validate.notBlank((CharSequence)dto.getProduceOrderId(), (String)"\u63d0\u4ea4\u6362\u8d27\u5355\u65f6\uff0c\u8ba2\u5355\u672a\u521b\u5efa\u6210\u529f", (Object[])new Object[0]);
        OrderVo orderVo = this.orderVoService.findById(dto.getProduceOrderId());
        Validate.notNull((Object)orderVo, (String)"\u63d0\u4ea4\u6362\u8d27\u5355\u65f6\uff0c\u8ba2\u5355\u672a\u521b\u5efa\u6210\u529f", (Object[])new Object[0]);
        this.orderHelper.occupyExchange(exchangeVo);
        this.commitProcess(dto);
    }

    private void commitValidation(ExchangeDto dto) {
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u6362\u8d27\u5355ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProcessBusiness().getProcessKey(), (String)"\u5ba1\u6279\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getExchangeCode(), (String)"\u6362\u8d27\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    public void commitProcess(ExchangeDto dto) {
        this.commitValidation(dto);
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        processBusiness.setProcessTitle(StringUtils.join((Object[])new String[]{"\u6362\u8d27\u5355\u5ba1\u6279", "\uff1a", dto.getExchangeCode()}));
        processBusiness.setBusinessNo(dto.getExchangeCode());
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)dto));
        processBusiness.setBusinessCode("exchange");
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        this.exchangeVoService.updateOrderStatusAndProcessNumberById(ExchangeStatusEnum.AWAIT_APPROVE.getDictCode(), processBusinessVo.getProcessNo(), dto.getId());
    }
}

