/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.exchange.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.PoolTypeEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CreditPoolTypeEnum;
import com.biz.crm.dms.business.costpool.replenishment.sdk.vo.CostPoolReplenishmentOrderProductVo;
import com.biz.crm.dms.business.costpool.replenishment.sdk.vo.CostPoolReplenishmentVo;
import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import com.biz.crm.dms.business.costpool.sdk.service.CostPoolVoService;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolVo;
import com.biz.crm.dms.business.exchange.local.entity.ExchangeEntity;
import com.biz.crm.dms.business.exchange.local.repository.ExchangeRepository;
import com.biz.crm.dms.business.exchange.sdk.dto.ExchangeDifferenceDto;
import com.biz.crm.dms.business.exchange.sdk.dto.ExchangeDto;
import com.biz.crm.dms.business.exchange.sdk.dto.ExchangePageDto;
import com.biz.crm.dms.business.exchange.sdk.enums.ExchangeStatusEnum;
import com.biz.crm.dms.business.exchange.sdk.enums.OperationGuideEnum;
import com.biz.crm.dms.business.exchange.sdk.event.ExchangeEventListener;
import com.biz.crm.dms.business.exchange.sdk.service.ExchangeDifferenceVoService;
import com.biz.crm.dms.business.exchange.sdk.service.ExchangeFileVoService;
import com.biz.crm.dms.business.exchange.sdk.service.ExchangeVoService;
import com.biz.crm.dms.business.exchange.sdk.strategy.ExchangeVerificationStrategy;
import com.biz.crm.dms.business.exchange.sdk.vo.ExchangeDifferenceVo;
import com.biz.crm.dms.business.exchange.sdk.vo.ExchangeVo;
import com.biz.crm.dms.business.order.common.sdk.enums.ItemTypeEnum;
import com.biz.crm.dms.business.order.sdk.dto.OrderConfirmDto;
import com.biz.crm.dms.business.order.sdk.dto.OrderDetailPreviewDto;
import com.biz.crm.dms.business.order.sdk.dto.OrderPayConfirmDto;
import com.biz.crm.dms.business.order.sdk.service.OrderConfirmService;
import com.biz.crm.dms.business.order.sdk.service.OrderVoService;
import com.biz.crm.dms.business.order.sdk.vo.OrderConfirmVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderDetailPreviewVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderVo;
import com.biz.crm.dms.business.returned.goods.sdk.dto.goods.ReturnedGoodsDto;
import com.biz.crm.dms.business.returned.goods.sdk.dto.goods.ReturnedGoodsReplenishmentDto;
import com.biz.crm.dms.business.returned.goods.sdk.enums.goods.PayTypeEnum;
import com.biz.crm.dms.business.returned.goods.sdk.enums.goods.ReturnedGoodsStatusEnum;
import com.biz.crm.dms.business.returned.goods.sdk.service.goods.ReturnedGoodsVoService;
import com.biz.crm.dms.business.returned.goods.sdk.vo.goods.ReturnedGoodsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExchangeVoServiceImpl
implements ExchangeVoService {
    private static final Logger log = LoggerFactory.getLogger(ExchangeVoServiceImpl.class);
    @Autowired(required=false)
    private ExchangeRepository exchangeRepository;
    @Autowired(required=false)
    private ExchangeDifferenceVoService exchangeDifferenceVoService;
    @Autowired(required=false)
    private ExchangeFileVoService exchangeFileVoService;
    @Autowired(required=false)
    private List<ExchangeEventListener> exchangeEventListeners;
    @Autowired(required=false)
    private List<ExchangeVerificationStrategy> exchangeVerificationStrategies;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ReturnedGoodsVoService returnedGoodsVoService;
    @Autowired(required=false)
    private OrderConfirmService orderConfirmService;
    @Autowired(required=false)
    private CostPoolVoService costPoolVoService;
    @Autowired(required=false)
    private OrderVoService orderVoService;

    public Page<ExchangeVo> findByConditions(Pageable pageable, ExchangePageDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new ExchangePageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.exchangeRepository.findByConditions((Page<ExchangePageDto>)page, dto);
    }

    public ExchangeVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ExchangeEntity entity = this.exchangeRepository.findById(id);
        if (entity == null) {
            return null;
        }
        ExchangeVo exchangeVo = (ExchangeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, ExchangeVo.class, HashSet.class, ArrayList.class, new String[0]);
        ReturnedGoodsVo returnedGoodsVo = this.returnedGoodsVoService.findDetailById(exchangeVo.getProduceReturnId());
        exchangeVo.setReturnedGoods(returnedGoodsVo);
        OrderVo orderVo = this.orderVoService.findById(exchangeVo.getProduceOrderId());
        exchangeVo.setOrder(orderVo);
        List differenceVoList = this.exchangeDifferenceVoService.findByExchangeCode(entity.getExchangeCode());
        exchangeVo.setDifferenceList(differenceVoList);
        List fileVoList = this.exchangeFileVoService.findByExchangeCode(entity.getExchangeCode());
        exchangeVo.setFileList(fileVoList);
        return exchangeVo;
    }

    private void fieldSummary(ExchangeDto dto, ReturnedGoodsVo returnedGoodsVo, OrderConfirmVo orderVo) {
        dto.setReturnQuantity(returnedGoodsVo.getQuantity());
        dto.setReturnAmount(returnedGoodsVo.getTotalAmount());
        if (orderVo != null) {
            BigDecimal totalQuantity = orderVo.getOrderDetails().stream().map(OrderDetailPreviewVo::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            dto.setExchangeQuantity(totalQuantity);
            dto.setExchangeAmount(orderVo.getTotalOrderAmount());
            dto.setDifferenceAmount(dto.getExchangeAmount().subtract(dto.getReturnAmount()));
        }
    }

    @Transactional
    public void draft(ExchangeDto dto) {
        this.createValidation(dto);
        Validate.isTrue((boolean)dto.getDraft(), (String)"\u6b64\u63a5\u53e3\u4e3a\u6682\u5b58\u65b0\u589e\u6216\u7f16\u8f91\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u63a5\u53e3\u8c03\u7528\u662f\u5426\u6b63\u786e", (Object[])new Object[0]);
        dto.setExchangeStatus(ExchangeStatusEnum.STAGING.getDictCode());
        dto.getReturnedGoods().setReturnedGoodsStatus(ReturnedGoodsStatusEnum.STAGING.getDictCode());
        dto.getReturnedGoods().setIsShow(BooleanEnum.FALSE.getCapital());
        dto.getReturnedGoods().setExternalSources("exchange");
        dto.getReturnedGoods().setPayType(PayTypeEnum.BALANCE.getDictCode());
        ReturnedGoodsVo returnedGoodsVo = null;
        returnedGoodsVo = StringUtils.isNotBlank((CharSequence)dto.getReturnedGoods().getId()) ? this.returnedGoodsVoService.updateByExchange(dto.getReturnedGoods()) : this.returnedGoodsVoService.createByExchange(dto.getReturnedGoods());
        Validate.notNull((Object)returnedGoodsVo, (String)"\u9000\u8d27\u5355\u521b\u5efa\u5931\u8d25\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)returnedGoodsVo.getId(), (String)"\u9000\u8d27\u5355\u521b\u5efa\u540e\u9000\u8d27\u5355ID\u83b7\u53d6\u5f02\u5e38\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)returnedGoodsVo.getReturnedGoodsCode(), (String)"\u9000\u8d27\u5355\u521b\u5efa\u540e\u9000\u8d27\u5355\u7f16\u7801\u83b7\u53d6\u5f02\u5e38\uff01", (Object[])new Object[0]);
        dto.setProduceReturnId(returnedGoodsVo.getId());
        dto.setProduceReturnCode(returnedGoodsVo.getReturnedGoodsCode());
        OrderConfirmVo orderVo = null;
        if (dto.getOrder() != null) {
            dto.getOrder().setIsShow(Boolean.FALSE);
            dto.getOrder().setExternalSources("exchange");
            orderVo = this.orderConfirmService.createOrUpdate(dto.getOrder());
            Validate.notNull((Object)orderVo, (String)"\u8ba2\u5355\u521b\u5efa\u5931\u8d25\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)orderVo.getId(), (String)"\u8ba2\u5355\u521b\u5efa\u540e\u8ba2\u5355ID\u83b7\u53d6\u5f02\u5e38\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)orderVo.getOrderCode(), (String)"\u8ba2\u5355\u521b\u5efa\u540e\u8ba2\u5355\u7f16\u7801\u83b7\u53d6\u5f02\u5e38\uff01", (Object[])new Object[0]);
            dto.setProduceOrderId(orderVo.getId());
            dto.setProduceOrderCode(orderVo.getOrderCode());
        }
        if (StringUtils.isBlank((CharSequence)dto.getExchangeCode())) {
            String ruleCode = StringUtils.join((Object[])new String[]{"HH", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
            List codeList = this.generateCodeService.generateCode(ruleCode, 1, Integer.valueOf(5), 2L, TimeUnit.DAYS);
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)codeList), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u751f\u6210\u6362\u8d27\u5355\u7f16\u7801\u5931\u8d25\uff01", (Object[])new Object[0]);
            dto.setExchangeCode((String)codeList.get(0));
        }
        this.fieldSummary(dto, returnedGoodsVo, orderVo);
        ExchangeEntity entity = (ExchangeEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ExchangeEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.exchangeRepository.saveOrUpdate((Object)entity);
        this.exchangeDifferenceVoService.createBatch(entity.getExchangeCode(), dto.getDifferenceList());
        this.exchangeFileVoService.createBatch(entity.getExchangeCode(), dto.getFileList());
    }

    private void buildDifferenceList(List<ExchangeDifferenceVo> differenceVoList, ExchangeDto dto, String poolType, BigDecimal diffAmount) {
        if (BigDecimal.ZERO.compareTo(diffAmount) == 0) {
            return;
        }
        CostPoolDto costPoolDto = new CostPoolDto();
        costPoolDto.setCustomerCode(dto.getCustomerCode());
        costPoolDto.setPoolType(poolType);
        List costPoolVoList = this.costPoolVoService.handleRequestCostPoolVos(costPoolDto);
        String poolCode = null;
        if (CollectionUtils.isNotEmpty((Collection)costPoolVoList)) {
            CostPoolVo costPoolVo = (CostPoolVo)costPoolVoList.get(0);
            poolCode = costPoolVo.getPoolCode();
        }
        if (CreditPoolTypeEnum.CREDIT.getDictCode().equals(poolType)) {
            ExchangeDifferenceVo credit = new ExchangeDifferenceVo();
            credit.setExchangeCode(dto.getExchangeCode());
            credit.setPoolType(CreditPoolTypeEnum.CREDIT.getDictCode());
            credit.setPoolGuide(BigDecimal.ZERO.compareTo(diffAmount) < 1 ? OperationGuideEnum.ON.getValue() : OperationGuideEnum.USE.getValue());
            credit.setExchangeAmount(diffAmount);
            credit.setSourceCode(poolCode);
            differenceVoList.add(credit);
        }
        if (PoolTypeEnum.CAPITAL.getDictCode().equals(poolType)) {
            ExchangeDifferenceVo capital = new ExchangeDifferenceVo();
            capital.setExchangeCode(dto.getExchangeCode());
            capital.setPoolType(PoolTypeEnum.CAPITAL.getDictCode());
            capital.setPoolGuide(BigDecimal.ZERO.compareTo(diffAmount) < 1 ? OperationGuideEnum.ON.getValue() : OperationGuideEnum.USE.getValue());
            capital.setSourceCode(poolCode);
            capital.setExchangeAmount(diffAmount);
            differenceVoList.add(capital);
        }
        if (com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolTypeEnum.DISCOUNT.getDictCode().equals(poolType)) {
            ExchangeDifferenceVo discount = new ExchangeDifferenceVo();
            discount.setExchangeCode(dto.getExchangeCode());
            discount.setPoolType(com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolTypeEnum.DISCOUNT.getDictCode());
            discount.setPoolGuide(BigDecimal.ZERO.compareTo(diffAmount) < 1 ? OperationGuideEnum.ON.getValue() : OperationGuideEnum.USE.getValue());
            discount.setSourceCode(poolCode);
            discount.setExchangeAmount(diffAmount);
            differenceVoList.add(discount);
        }
    }

    public ExchangeVo difference(ExchangeDto dto) {
        this.submitValidate(dto);
        ReturnedGoodsDto returnedGoodsDto = dto.getReturnedGoods();
        BigDecimal creditAmountReturned = Objects.isNull(returnedGoodsDto.getCreditAmount()) ? BigDecimal.ZERO : returnedGoodsDto.getCreditAmount();
        BigDecimal capitalAmountReturned = Objects.isNull(returnedGoodsDto.getCapitalAmount()) ? BigDecimal.ZERO : returnedGoodsDto.getCapitalAmount();
        BigDecimal discountAmountReturned = Objects.isNull(returnedGoodsDto.getDiscountAmount()) ? BigDecimal.ZERO : returnedGoodsDto.getDiscountAmount();
        List orderConfirmPays = dto.getOrder().getOrderPays();
        Validate.notNull((Object)orderConfirmPays, (String)"\u8ba2\u5355\u603b\u7684\u8bb0\u8d26\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Map orderPayConfirmDtoMap = orderConfirmPays.stream().collect(Collectors.toMap(OrderPayConfirmDto::getItemKey, Function.identity()));
        BigDecimal creditAmountOrder = Objects.isNull(orderPayConfirmDtoMap.get(CreditPoolTypeEnum.CREDIT.getDictCode())) ? BigDecimal.ZERO : ((OrderPayConfirmDto)orderPayConfirmDtoMap.get(CreditPoolTypeEnum.CREDIT.getDictCode())).getItemAmount();
        BigDecimal capitalAmountOrder = Objects.isNull(orderPayConfirmDtoMap.get(PoolTypeEnum.CAPITAL.getDictCode())) ? BigDecimal.ZERO : ((OrderPayConfirmDto)orderPayConfirmDtoMap.get(PoolTypeEnum.CAPITAL.getDictCode())).getItemAmount();
        BigDecimal discountAmountOrder = Objects.isNull(orderPayConfirmDtoMap.get(com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolTypeEnum.DISCOUNT.getDictCode())) ? BigDecimal.ZERO : ((OrderPayConfirmDto)orderPayConfirmDtoMap.get(com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolTypeEnum.DISCOUNT.getDictCode())).getItemAmount();
        BigDecimal creditAmount = creditAmountReturned.subtract(creditAmountOrder).setScale(4, 0);
        BigDecimal capitalAmount = capitalAmountReturned.subtract(capitalAmountOrder).setScale(4, 0);
        BigDecimal discountAmount = discountAmountReturned.subtract(discountAmountOrder).setScale(4, 0);
        ArrayList<ExchangeDifferenceVo> differenceVoList = new ArrayList<ExchangeDifferenceVo>();
        this.buildDifferenceList(differenceVoList, dto, CreditPoolTypeEnum.CREDIT.getDictCode(), creditAmount);
        this.buildDifferenceList(differenceVoList, dto, PoolTypeEnum.CAPITAL.getDictCode(), capitalAmount);
        this.buildDifferenceList(differenceVoList, dto, com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolTypeEnum.DISCOUNT.getDictCode(), discountAmount);
        CostPoolDto costPoolDto3 = new CostPoolDto();
        costPoolDto3.setCustomerCode(dto.getCustomerCode());
        costPoolDto3.setPoolType(com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolTypeEnum.Replenishment.getDictCode());
        List costPoolReplenishmentVoList = this.costPoolVoService.handleRequestCostPoolVos(costPoolDto3);
        Map costPoolReplenishmentMap = ((List)Optional.ofNullable(costPoolReplenishmentVoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(CostPoolVo::getPoolCode, Function.identity()));
        List replenishmentList = Optional.ofNullable(returnedGoodsDto.getReplenishmentList()).orElse(new ArrayList());
        Map<String, List<ReturnedGoodsReplenishmentDto>> returnedGoodsReplenishmentMap = replenishmentList.stream().collect(Collectors.groupingBy(ReturnedGoodsReplenishmentDto::getReplenishmentCode));
        Set<String> returnedGoodsReplenishmentCodes = replenishmentList.stream().map(ReturnedGoodsReplenishmentDto::getReplenishmentCode).collect(Collectors.toSet());
        List orderDetails = Optional.ofNullable(dto.getOrder().getOrderDetails()).orElse(new ArrayList());
        Map<String, List<OrderDetailPreviewDto>> orderReplenishmentMap = orderDetails.stream().filter(o -> ItemTypeEnum.COMPENSATED_GOODS.getDictCode().equals(o.getItemType())).collect(Collectors.groupingBy(OrderDetailPreviewDto::getItemCode));
        Set orderReplenishmentCodes = orderDetails.stream().filter(o -> ItemTypeEnum.COMPENSATED_GOODS.getDictCode().equals(o.getItemType())).map(OrderDetailPreviewDto::getItemCode).collect(Collectors.toSet());
        returnedGoodsReplenishmentCodes.addAll(orderReplenishmentCodes);
        returnedGoodsReplenishmentCodes.forEach(replenishmentCode -> {
            List orderDetailPreviewDtoList;
            BigDecimal replenishmentAmountOrder;
            List returnedGoodsReplenishmentDtoList = (List)returnedGoodsReplenishmentMap.get(replenishmentCode);
            BigDecimal replenishmentAmountReturned = ((List)Optional.ofNullable(returnedGoodsReplenishmentDtoList).orElse(new ArrayList())).stream().map(ReturnedGoodsReplenishmentDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal replenishmentAmount = replenishmentAmountReturned.subtract(replenishmentAmountOrder = ((List)Optional.ofNullable(orderDetailPreviewDtoList = (List)orderReplenishmentMap.get(replenishmentCode)).orElse(new ArrayList())).stream().map(OrderDetailPreviewDto::getSalesAmount).reduce(BigDecimal.ZERO, BigDecimal::add)).setScale(4, 0);
            if (BigDecimal.ZERO.compareTo(replenishmentAmount) == 0) {
                return;
            }
            CostPoolReplenishmentVo costPoolReplenishmentVo = (CostPoolReplenishmentVo)costPoolReplenishmentMap.get(replenishmentCode);
            ExchangeDifferenceVo replenishment = new ExchangeDifferenceVo();
            replenishment.setExchangeCode(dto.getExchangeCode());
            replenishment.setPoolType(com.biz.crm.dms.business.costpool.replenishment.sdk.enums.PoolTypeEnum.Replenishment.getDictCode());
            replenishment.setPoolGuide(BigDecimal.ZERO.compareTo(replenishmentAmount) < 1 ? OperationGuideEnum.ON.getValue() : OperationGuideEnum.USE.getValue());
            replenishment.setExchangeAmount(replenishmentAmount);
            if (costPoolReplenishmentVo != null) {
                replenishment.setSourceCode(costPoolReplenishmentVo.getPoolCode());
                List productVos = costPoolReplenishmentVo.getCostPoolReplenishmentProduct();
                if (CollectionUtils.isNotEmpty((Collection)productVos)) {
                    replenishment.setSourceBind(StringUtils.join((Iterable)productVos.stream().map(CostPoolReplenishmentOrderProductVo::getGoodsProductName).collect(Collectors.toList()), (String)"|"));
                } else {
                    replenishment.setSourceBind(costPoolReplenishmentVo.getGoodsProductLevelName());
                }
            }
            differenceVoList.add(replenishment);
        });
        ExchangeVo exchangeVo = (ExchangeVo)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, ExchangeVo.class, HashSet.class, LinkedList.class, new String[0]);
        exchangeVo.setDifferenceList(differenceVoList);
        return exchangeVo;
    }

    @Transactional
    public ExchangeVo createOrUpdate(ExchangeDto dto) {
        this.createValidation(dto);
        this.submitValidate(dto);
        Validate.notNull((Object)dto.getDifferenceList(), (String)"\u6362\u8d27\u5355\u5dee\u989d\u96c6\u5408\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dto.getDraft() == false ? 1 : 0) != 0, (String)"\u6b64\u63a5\u53e3\u4e3a\u63d0\u4ea4\u5ba1\u6279\u4e0d\u662f\u6682\u5b58\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u63a5\u53e3\u8c03\u7528\u662f\u5426\u6b63\u786e", (Object[])new Object[0]);
        dto.setExchangeStatus(ExchangeStatusEnum.AWAIT_APPROVE.getDictCode());
        dto.getReturnedGoods().setReturnedGoodsStatus(ReturnedGoodsStatusEnum.UNDER_REVIEW.getDictCode());
        dto.getReturnedGoods().setIsShow(BooleanEnum.FALSE.getCapital());
        dto.getReturnedGoods().setExternalSources("exchange");
        ReturnedGoodsVo returnedGoodsVo = null;
        returnedGoodsVo = StringUtils.isNotBlank((CharSequence)dto.getReturnedGoods().getId()) ? this.returnedGoodsVoService.updateByExchange(dto.getReturnedGoods()) : this.returnedGoodsVoService.createByExchange(dto.getReturnedGoods());
        Validate.notNull((Object)returnedGoodsVo, (String)"\u9000\u8d27\u5355\u521b\u5efa\u5931\u8d25\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)returnedGoodsVo.getId(), (String)"\u9000\u8d27\u5355\u521b\u5efa\u540e\u9000\u8d27\u5355ID\u83b7\u53d6\u5f02\u5e38\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)returnedGoodsVo.getReturnedGoodsCode(), (String)"\u9000\u8d27\u5355\u521b\u5efa\u540e\u9000\u8d27\u5355\u7f16\u7801\u83b7\u53d6\u5f02\u5e38\uff01", (Object[])new Object[0]);
        dto.setProduceReturnId(returnedGoodsVo.getId());
        dto.setProduceReturnCode(returnedGoodsVo.getReturnedGoodsCode());
        dto.getOrder().setIsShow(Boolean.FALSE);
        dto.getOrder().setExternalSources("exchange");
        OrderConfirmVo orderVo = this.orderConfirmService.handleConfirmWithoutResource(dto.getOrder());
        Validate.notNull((Object)orderVo, (String)"\u8ba2\u5355\u521b\u5efa\u5931\u8d25\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)orderVo.getId(), (String)"\u8ba2\u5355\u521b\u5efa\u540e\u8ba2\u5355ID\u83b7\u53d6\u5f02\u5e38\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)orderVo.getOrderCode(), (String)"\u8ba2\u5355\u521b\u5efa\u540e\u8ba2\u5355\u7f16\u7801\u83b7\u53d6\u5f02\u5e38\uff01", (Object[])new Object[0]);
        dto.setProduceOrderId(orderVo.getId());
        dto.setProduceOrderCode(orderVo.getOrderCode());
        if (StringUtils.isBlank((CharSequence)dto.getExchangeCode())) {
            String ruleCode = StringUtils.join((Object[])new String[]{"HH", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
            List codeList = this.generateCodeService.generateCode(ruleCode, 1, Integer.valueOf(5), 2L, TimeUnit.DAYS);
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)codeList), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u751f\u6210\u6362\u8d27\u5355\u7f16\u7801\u5931\u8d25\uff01", (Object[])new Object[0]);
            dto.setExchangeCode((String)codeList.get(0));
        }
        this.fieldSummary(dto, returnedGoodsVo, orderVo);
        if (CollectionUtils.isNotEmpty(this.exchangeVerificationStrategies)) {
            this.exchangeVerificationStrategies = this.exchangeVerificationStrategies.stream().sorted(Comparator.comparing(ExchangeVerificationStrategy::order)).collect(Collectors.toList());
            this.exchangeVerificationStrategies.forEach(t -> t.execute(dto));
        }
        ExchangeEntity entity = (ExchangeEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ExchangeEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.exchangeRepository.saveOrUpdate((Object)entity);
        dto.setId(entity.getId());
        OrderConfirmDto orderConfirmDto = (OrderConfirmDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)orderVo, OrderConfirmDto.class, HashSet.class, ArrayList.class, new String[]{"orderPays", "orderDetails", "orderDetails.orderDetailPays"});
        dto.setOrder(orderConfirmDto);
        ExchangeVo exchangeVoReal = this.difference(dto);
        exchangeVoReal.setId(entity.getId());
        List differenceDtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)exchangeVoReal.getDifferenceList(), ExchangeDifferenceVo.class, ExchangeDifferenceDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.exchangeDifferenceVoService.createBatch(entity.getExchangeCode(), differenceDtoList);
        this.exchangeFileVoService.createBatch(entity.getExchangeCode(), dto.getFileList());
        if (CollectionUtils.isNotEmpty(this.exchangeEventListeners)) {
            this.exchangeEventListeners.forEach(event -> event.onCreate(exchangeVoReal));
        }
        return exchangeVoReal;
    }

    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ExchangeEntity> entities = this.exchangeRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        HashSet set = Sets.newHashSet((Object[])new String[]{ExchangeStatusEnum.STAGING.getDictCode(), ExchangeStatusEnum.REJECTED.getDictCode(), ExchangeStatusEnum.CANCELED.getDictCode()});
        entities.forEach(e -> Validate.isTrue((boolean)set.contains(e.getExchangeStatus()), (String)String.format("\u53ef\u5220\u9664\u5ba1\u6279\u9a73\u56de\u3001\u6682\u5b58\u3001\u6d41\u7a0b\u8ffd\u56de\u72b6\u6001\u7684\u6362\u8d27\u5355\uff0c\u7f16\u7801[%s]\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u5220\u9664", e.getExchangeCode()), (Object[])new Object[0]));
        this.exchangeRepository.updateDelFlagByIds(ids);
        if (CollectionUtils.isNotEmpty(this.exchangeEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, ExchangeEntity.class, ExchangeVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.exchangeEventListeners.forEach(event -> event.onDelete(voList));
        }
    }

    public ExchangeVo findByExchangeCode(String exchangeCode) {
        if (StringUtils.isBlank((CharSequence)exchangeCode)) {
            return null;
        }
        ExchangeEntity entity = this.exchangeRepository.findByExchangeCode(exchangeCode);
        if (entity == null) {
            return null;
        }
        ExchangeVo exchangeVo = (ExchangeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, ExchangeVo.class, HashSet.class, ArrayList.class, new String[0]);
        List differenceVoList = this.exchangeDifferenceVoService.findByExchangeCode(exchangeCode);
        exchangeVo.setDifferenceList(differenceVoList);
        return exchangeVo;
    }

    public void updateExchangeStatusById(String exchangeStatus, String id) {
        Validate.notBlank((CharSequence)exchangeStatus, (String)"\u6362\u8d27\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)id, (String)"\u6362\u8d27\u5355ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.exchangeRepository.updateExchangeStatusById(exchangeStatus, id);
    }

    public void updateOrderStatusAndProcessNumberById(String exchangeStatus, String processNumber, String id) {
        this.exchangeRepository.updateOrderStatusAndProcessNumberById(exchangeStatus, processNumber, id);
    }

    public ExchangeVo findDetailByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        ExchangeEntity entity = this.exchangeRepository.findByExchangeCode(code);
        if (entity == null) {
            return null;
        }
        ExchangeVo exchangeVo = (ExchangeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, ExchangeVo.class, HashSet.class, ArrayList.class, new String[0]);
        ReturnedGoodsVo returnedGoodsVo = this.returnedGoodsVoService.findDetailById(exchangeVo.getProduceReturnId());
        exchangeVo.setReturnedGoods(returnedGoodsVo);
        OrderVo orderVo = this.orderVoService.findById(exchangeVo.getProduceOrderId());
        exchangeVo.setOrder(orderVo);
        List differenceVoList = this.exchangeDifferenceVoService.findByExchangeCode(entity.getExchangeCode());
        exchangeVo.setDifferenceList(differenceVoList);
        List fileVoList = this.exchangeFileVoService.findByExchangeCode(entity.getExchangeCode());
        exchangeVo.setFileList(fileVoList);
        return exchangeVo;
    }

    private void createValidation(ExchangeDto dto) {
        this.validation(dto);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    }

    private void updateValidation(ExchangeDto dto) {
        this.validation(dto);
        Validate.notBlank((CharSequence)dto.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getDifferenceList(), (String)"\u6362\u8d27\u5355\u5dee\u989d\u96c6\u5408\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void validation(ExchangeDto dto) {
        Validate.notNull((Object)dto, (String)"\u6362\u8d27\u5355\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getDraft(), (String)"\u6682\u5b58\u6807\u8bc6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getExchangeTime(), (String)"\u6362\u8d27\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOriginalOrderCode(), (String)"\u539f\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCustomerName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getReason(), (String)"\u6362\u8d27\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getReturnedGoods(), (String)"\u9000\u8d27\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)dto.getId())) {
            ExchangeEntity oldEntity = this.exchangeRepository.findById(dto.getId());
            Validate.notNull((Object)((Object)oldEntity), (String)"\u6362\u8d27\u5355\u5bf9\u8c61\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664", (Object[])new Object[0]);
            HashSet set = Sets.newHashSet((Object[])new String[]{ExchangeStatusEnum.STAGING.getDictCode(), ExchangeStatusEnum.REJECTED.getDictCode(), ExchangeStatusEnum.CANCELED.getDictCode()});
            Validate.isTrue((boolean)set.contains(oldEntity.getExchangeStatus()), (String)"\u5f53\u524d\u6362\u8d27\u5355\u72b6\u6001\u4e0d\u80fd\u7f16\u8f91\uff0c\u53ef\u7f16\u8f91\u5ba1\u6279\u9a73\u56de\u3001\u6682\u5b58\u3001\u6d41\u7a0b\u8ffd\u56de\u72b6\u6001\u7684\u6362\u8d27\u5355", (Object[])new Object[0]);
        }
    }

    private void submitValidate(ExchangeDto dto) {
        Validate.notNull((Object)dto.getReturnedGoods(), (String)"\u9000\u8d27\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getOrder(), (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

