/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.exchange.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.delivery.sdk.dto.DeliveryUnshippedPageDto;
import com.biz.crm.dms.business.delivery.sdk.service.DeliveryUnshippedVoService;
import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryUnshippedVo;
import com.biz.crm.dms.business.exchange.sdk.service.ExchangeableVoService;
import com.biz.crm.dms.business.exchange.sdk.vo.ExchangeableVo;
import com.biz.crm.dms.business.returned.goods.sdk.service.goods.ReturnedGoodsVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ExchangeableVoServiceImpl
implements ExchangeableVoService {
    private static final Logger log = LoggerFactory.getLogger(ExchangeableVoServiceImpl.class);
    @Autowired(required=false)
    private DeliveryUnshippedVoService deliveryUnshippedVoService;
    @Autowired(required=false)
    private ReturnedGoodsVoService returnedGoodsVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Page<ExchangeableVo> findByOrderUnshippedPageDto(Pageable pageable, DeliveryUnshippedPageDto deliveryUnshippedPageDto) {
        Page orderPage;
        if (Objects.isNull(deliveryUnshippedPageDto)) {
            deliveryUnshippedPageDto = new DeliveryUnshippedPageDto();
        }
        if ((orderPage = this.deliveryUnshippedVoService.findByOrderUnshippedPageDto(pageable, deliveryUnshippedPageDto)) == null || CollectionUtils.isEmpty((Collection)orderPage.getRecords())) {
            return new Page();
        }
        List records = orderPage.getRecords();
        List exchangeableVoList = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)records, DeliveryUnshippedVo.class, ExchangeableVo.class, HashSet.class, LinkedList.class, new String[0]);
        List orderCodes = exchangeableVoList.stream().map(DeliveryUnshippedVo::getOrderCode).distinct().collect(Collectors.toList());
        Map returnQuantityMap = this.returnedGoodsVoService.findQuantityByOrderCodes(orderCodes);
        if (!returnQuantityMap.isEmpty()) {
            exchangeableVoList.forEach(o -> {
                BigDecimal returnQuantity;
                BigDecimal bigDecimal = returnQuantity = returnQuantityMap.get(o.getOrderCode()) == null ? BigDecimal.ZERO : (BigDecimal)returnQuantityMap.get(o.getOrderCode());
                if (returnQuantity.compareTo(o.getDeliveryQuantity()) == -1) {
                    o.setExchangeable(Boolean.TRUE);
                }
            });
        }
        Page exchangeableVoPage = new Page(orderPage.getCurrent(), orderPage.getSize(), orderPage.getTotal());
        exchangeableVoPage.setRecords(exchangeableVoList);
        return exchangeableVoPage;
    }
}

