/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.exchange.local.strategy;

import com.biz.crm.dms.business.costpool.credit.sdk.enums.CreditPoolTypeEnum;
import com.biz.crm.dms.business.exchange.local.service.helper.ReturnGoodsHelper;
import com.biz.crm.dms.business.exchange.sdk.dto.ExchangeDto;
import com.biz.crm.dms.business.exchange.sdk.strategy.ExchangeVerificationStrategy;
import com.biz.crm.dms.business.order.sdk.service.OrderVoService;
import com.biz.crm.dms.business.order.sdk.vo.OrderPayVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderVo;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreditAmountVerificationStrategyImpl
implements ExchangeVerificationStrategy {
    private static final Logger log = LoggerFactory.getLogger(CreditAmountVerificationStrategyImpl.class);
    @Autowired(required=false)
    private ReturnGoodsHelper returnGoodsHelper;
    @Autowired(required=false)
    private OrderVoService orderVoService;

    public void execute(ExchangeDto exchangeDto) {
        Validate.notNull((Object)exchangeDto.getOrder(), (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)exchangeDto.getReturnedGoods(), (String)"\u9000\u8d27\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List orderVoList = this.orderVoService.findByOrderCodes(Collections.singletonList(exchangeDto.getOriginalOrderCode()));
        Validate.notEmpty((Collection)orderVoList, (String)"\u539f\u8ba2\u5355\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        List orderPays = ((OrderVo)orderVoList.get(0)).getOrderPays();
        Validate.notEmpty((Collection)orderPays, (String)"\u539f\u8ba2\u5355\u603b\u7684\u8bb0\u8d26\u9879\u76ee\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Optional<OrderPayVo> optionalOrderPayVo = orderPays.stream().filter(o -> CreditPoolTypeEnum.CREDIT.getDictCode().equals(o.getItemKey())).findFirst();
        if (!optionalOrderPayVo.isPresent()) {
            return;
        }
        BigDecimal orderUseCreditAmount = optionalOrderPayVo.get().getItemAmount();
        BigDecimal totalCreditAmount = this.returnGoodsHelper.getReturnedAmount(exchangeDto.getOriginalOrderCode(), exchangeDto.getProduceReturnCode());
        BigDecimal balance = orderUseCreditAmount.subtract(totalCreditAmount);
        Validate.isTrue((exchangeDto.getReturnedGoods().getCreditAmount().compareTo(balance) <= 0 ? 1 : 0) != 0, (String)("\u6388\u4fe1\u91d1\u989d\u8d85\u51fa\uff0c\u5f53\u524d\u9000\u8fd8\u7684\u6388\u4fe1\u91d1\u989d\u4e3a\uff1a" + exchangeDto.getReturnedGoods().getCreditAmount() + ",\u6700\u5927\u53ef\u9000\u6388\u4fe1\u91d1\u989d\u4e3a:" + balance), (Object[])new Object[0]);
    }

    public int order() {
        return 3;
    }
}

