/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.exchange.local.strategy;

import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import com.biz.crm.dms.business.costpool.sdk.service.CostPoolVoService;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolVo;
import com.biz.crm.dms.business.exchange.sdk.dto.ExchangeDto;
import com.biz.crm.dms.business.exchange.sdk.strategy.ExchangeVerificationStrategy;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DifferenceVerificationStrategyImpl
implements ExchangeVerificationStrategy {
    private static final Logger log = LoggerFactory.getLogger(DifferenceVerificationStrategyImpl.class);
    @Autowired(required=false)
    private CostPoolVoService costPoolVoService;

    public void execute(ExchangeDto exchangeDto) {
        Validate.notEmpty((Collection)exchangeDto.getDifferenceList(), (String)"\u6362\u8d27\u5355\u5dee\u989d\u96c6\u5408\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List differenceDtoList = exchangeDto.getDifferenceList();
        differenceDtoList.forEach(diff -> {
            if (BigDecimal.ZERO.compareTo(diff.getExchangeAmount()) < 1) {
                return;
            }
            CostPoolDto costPoolDto = new CostPoolDto();
            costPoolDto.setPoolType(diff.getPoolType());
            costPoolDto.setCustomerCode(exchangeDto.getCustomerCode());
            List costPoolVoList = this.costPoolVoService.handleRequestCostPoolVos(costPoolDto);
            Validate.notEmpty((Collection)costPoolVoList, (String)String.format("\u672a\u83b7\u53d6\u5230\u7c7b\u578b\u4e3a[%s]\u7684\u8d39\u7528\u6c60\u6570\u636e\uff01", diff.getPoolType()), (Object[])new Object[0]);
            CostPoolVo costPoolVo = (CostPoolVo)costPoolVoList.get(0);
            Validate.isTrue((diff.getExchangeAmount().abs().compareTo(costPoolVo.getUsableAmount()) < 1 ? 1 : 0) != 0, (String)String.format("\u5f53\u524d\u5dee\u989d\u7edd\u5bf9\u503c%s\uff0c\u8d85\u51fa\u8d39\u7528\u6c60[%s]\u5f53\u524d\u53ef\u7528\u4f59\u989d%s\uff01", diff.getExchangeAmount().abs(), diff.getSourceCode(), costPoolVo.getUsableAmount()), (Object[])new Object[0]);
        });
    }

    public int order() {
        return 1;
    }
}

