/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.exchange.local.strategy;

import com.biz.crm.dms.business.exchange.sdk.dto.ExchangeDto;
import com.biz.crm.dms.business.exchange.sdk.strategy.ExchangeVerificationStrategy;
import com.biz.crm.dms.business.returned.goods.sdk.dto.goods.ReturnedGoodsDto;
import com.biz.crm.dms.business.returned.goods.sdk.dto.goods.ReturnedGoodsReplenishmentDto;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ReplenishmentVerificationStrategyImpl
implements ExchangeVerificationStrategy {
    private static final Logger log = LoggerFactory.getLogger(ReplenishmentVerificationStrategyImpl.class);

    public void execute(ExchangeDto exchangeDto) {
        Validate.notNull((Object)exchangeDto.getReturnedGoods(), (String)"\u9000\u8d27\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ReturnedGoodsDto returnedGoodsDto = exchangeDto.getReturnedGoods();
        if (returnedGoodsDto.getReplenishmentAmount() == null) {
            return;
        }
        List replenishmentList = returnedGoodsDto.getReplenishmentList();
        if (CollectionUtils.isEmpty((Collection)replenishmentList)) {
            return;
        }
        BigDecimal replenishmentAmount = replenishmentList.stream().map(ReturnedGoodsReplenishmentDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        Validate.isTrue((returnedGoodsDto.getReplenishmentAmount().compareTo(replenishmentAmount) == 0 ? 1 : 0) != 0, (String)"\u5fc5\u987b\u6ee1\u8db3\uff1a\u8d27\u8865\u660e\u7ec6\u5217\u8868\u4e2d\u586b\u5199\u7684\u201c\u8d27\u8865\u91d1\u989d\u201d\u7684\u52a0\u548c=\u672c\u5355\u9000\u8fd8\u8d27\u8865\u8d39\u7528", (Object[])new Object[0]);
    }

    public int order() {
        return 1;
    }
}

