package com.biz.crm.dms.business.exchange.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 换货单差额子表dto
 *
 * @author xi.peng
 * @since 2022-07-07 09:35:52
 */
@Data
@ApiModel(value = "DmsOrderExchangeDifferenceDto", description = "换货单差额子表dto")
public class ExchangeDifferenceDto extends TenantFlagOpDto {

  @ApiModelProperty("换货单编码")
  private String exchangeCode;

  @ApiModelProperty("池子类型")
  private String poolType;

  @ApiModelProperty("指导在池子方的操作（金额正上账，负使用）")
  private String poolGuide;

  @ApiModelProperty("来源编码")
  private String sourceCode;

  @ApiModelProperty("来源绑定信息")
  private String sourceBind;

  @ApiModelProperty("金额(元)")
  private BigDecimal exchangeAmount;
}

