package com.biz.crm.dms.business.exchange.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 换货单主表实体分页查询dto
 *
 * @author xi.peng
 * @since 2022-07-06 19:03:27
 */
@Data
@ApiModel(value = "DmsOrderExchangePageDto", description = "换货单主表实体分页查询dto")
public class ExchangePageDto extends TenantFlagOpDto {

  @ApiModelProperty("产生的订单编号")
  private String produceOrderCode;

  @ApiModelProperty("产生的退货订单编号")
  private String produceReturnCode;

  @ApiModelProperty("换货单编码")
  private String exchangeCode;

  @ApiModelProperty("换货单状态")
  private String exchangeStatus;

  @ApiModelProperty("换货单状态集合")
  private List<String> exchangeStatusList;

  @ApiModelProperty("客户编码")
  private String customerCode;

  @ApiModelProperty("客户名称")
  private String customerName;
}

