package com.biz.crm.dms.business.exchange.sdk.enums;

import com.biz.crm.dms.business.order.common.sdk.service.VisibleEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Optional;
import java.util.stream.Stream;

/**
 * 换货单状态-枚举
 * 暂存、审批中、审批通过、审批驳回、流程撤回
 *
 * @author pengxi
 */
@Getter
@AllArgsConstructor
public enum ExchangeStatusEnum implements VisibleEnum {

  /**
   * 暂存
   */
  STAGING("STAGING", "staging", "暂存", "1"),
  /**
   * 审批中、待审批
   */
  AWAIT_APPROVE("AWAIT_APPROVE", "awaitApprove", "审批中", "2"),
  /**
   * 审批驳回
   */
  REJECTED("REJECTED", "rejected", "审批驳回", "3"),
  /**
   * 已取消、流程撤回
   */
  CANCELED("CANCELED", "canceled", "流程撤回", "4"),
  /**
   * 已完成、审批通过
   */
  COMPLETED("COMPLETED", "completed", "已完成", "5"),
  ;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  public static ExchangeStatusEnum findByCode(String code) {
    Optional<ExchangeStatusEnum> first = Stream.of(ExchangeStatusEnum.values()).filter(t -> t.dictCode.equals(code)).findFirst();
    return first.orElse(null);
  }
}
