package com.biz.crm.dms.business.exchange.sdk.event;

import com.biz.crm.dms.business.exchange.sdk.vo.ExchangeVo;

import java.util.List;

/**
 * 换货单主表实体变更事件通知接口
 *
 * @author xi.peng
 * @since 2022-07-06 19:03:27
 */
public interface ExchangeEventListener {

  /**
   * 创建时触发
   *
   * @param vo 换货单vo
   */
  default void onCreate(ExchangeVo vo) {
  }

  /**
   * 编辑时触发
   *
   * @param oldVo 旧的换货单vo
   * @param newVo 新的换货单vo
   */
  default void onUpdate(ExchangeVo oldVo, ExchangeVo newVo) {

  }

  /**
   * 启用时触发
   *
   * @param list 换货单vo集合
   */
  default void onEnable(List<ExchangeVo> list) {

  }

  /**
   * 禁用时触发
   *
   * @param list 换货单vo集合
   */
  default void onDisable(List<ExchangeVo> list) {
  }

  /**
   * 删除时触发
   *
   * @param list 换货单vo集合
   */
  default void onDelete(List<ExchangeVo> list) {

  }
}

