package com.biz.crm.dms.business.exchange.sdk.service;

import java.util.List;

import com.biz.crm.dms.business.exchange.sdk.vo.ExchangeDifferenceVo;
import com.biz.crm.dms.business.exchange.sdk.dto.ExchangeDifferenceDto;

/**
 * 换货单差额子表(DmsOrderExchangeDifference)表服务接口
 *
 * @author xi.peng
 * @since 2022-07-07 09:35:52
 */
public interface ExchangeDifferenceVoService {

  /**
   * 按换货单编码查询
   *
   * @param exchangeCode 换货单编码
   * @return List<DmsOrderExchangeDifferenceVo>
   */
  List<ExchangeDifferenceVo> findByExchangeCode(String exchangeCode);

  /**
   * 批量创建
   *
   * @param exchangeCode 换货单编码
   * @param dtoList 换货单差额dto集合
   */
  void createBatch(String exchangeCode, List<ExchangeDifferenceDto> dtoList);

  /**
   * 批量更新
   *
   * @param dtoList 换货单差额dto集合
   */
  void updateBatch(List<ExchangeDifferenceDto> dtoList);


}
