package com.biz.crm.dms.business.exchange.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.biz.crm.dms.business.exchange.sdk.dto.ExchangeDto;
import com.biz.crm.dms.business.exchange.sdk.dto.ExchangePageDto;
import com.biz.crm.dms.business.exchange.sdk.vo.ExchangeVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 换货单主表实体(DmsOrderExchange)表服务接口
 *
 * @author xi.peng
 * @since 2022-07-06 19:03:27
 */
public interface ExchangeVoService {

  /**
   * 分页条件查询
   *
   * @param pageable 分页参数
   * @param dto 换货单dto
   * @return Page<DmsOrderExchangeVo>
   */
  Page<ExchangeVo> findByConditions(Pageable pageable, ExchangePageDto dto);

  /**
   * 按id查询详情
   *
   * @param id 换货单ID
   * @return DmsOrderExchangeVo
   */
  ExchangeVo findDetailById(String id);

  /**
   * 暂存
   *
   * @param dto 换货单dto
   */
  void draft(ExchangeDto dto);

  /**
   * 差额
   *
   * @param dto 换货单dto
   * @return ExchangeVo
   */
  ExchangeVo difference(ExchangeDto dto);

  /**
   * 创建或更新（非暂存逻辑）
   *
   * @param dto 换货单dto
   */
  ExchangeVo createOrUpdate(ExchangeDto dto);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 根据换货单编码查询
   *
   * @param exchangeCode 换货单编码
   * @return DmsOrderExchangeVo
   */
  ExchangeVo findByExchangeCode(String exchangeCode);

  /**
   * 根据 id 修改 exchangeStatus
   *
   * @param exchangeStatus 换货单状态
   * @param id 换货单ID
   */
  void updateExchangeStatusById(String exchangeStatus, String id);

  /**
   * 根据 id 修改 exchangeStatus
   *
   * @param exchangeStatus 换货单状态
   * @param processNumber 审批单号
   * @param id 换货单ID
   */
  void updateOrderStatusAndProcessNumberById(String exchangeStatus,String processNumber, String id);
}
