package com.biz.crm.dms.business.exchange.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderVo;
import com.biz.crm.dms.business.returned.goods.sdk.vo.goods.ReturnedGoodsVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 换货单主表实体vo
 *
 * @author xi.peng
 * @since 2022-07-06 19:03:28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "换货单主表实体Vo")
public class ExchangeVo extends TenantFlagOpVo {

  @ApiModelProperty("原订单编号")
  private String originalOrderCode;

  @ApiModelProperty("原订单ID")
  private String originalOrderId;

  @ApiModelProperty("产生的订单编号")
  private String produceOrderCode;

  @ApiModelProperty("产生的订单ID")
  private String produceOrderId;

  @ApiModelProperty("产生的退货订单编号")
  private String produceReturnCode;

  @ApiModelProperty("产生的退货订单ID")
  private String produceReturnId;

  @ApiModelProperty("换货单编码")
  private String exchangeCode;

  @ApiModelProperty("换货单来源")
  private String exchangeSource;

  @ApiModelProperty("换货单状态")
  private String exchangeStatus;

  @ApiModelProperty("换货类型")
  private String exchangeType;

  @ApiModelProperty("换货时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date exchangeTime;

  @ApiModelProperty("换货金额(元)")
  private BigDecimal exchangeAmount;

  @ApiModelProperty("换货数量")
  private BigDecimal exchangeQuantity;

  @ApiModelProperty("退货金额(元)")
  private BigDecimal returnAmount;

  @ApiModelProperty("退货数量")
  private BigDecimal returnQuantity;

  @ApiModelProperty("差额(元)")
  private BigDecimal differenceAmount;

  @ApiModelProperty("换货原因")
  private String reason;

  @ApiModelProperty("客户编码")
  private String customerCode;

  @ApiModelProperty("客户名称")
  private String customerName;

  @ApiModelProperty("审批流程编码")
  private String processKey;

  @ApiModelProperty("审批单号")
  private String processNumber;

  @ApiModelProperty("审批备注")
  private String processRemark;

  @ApiModelProperty("审批状态")
  private Integer processStatus;

  @ApiModelProperty("换货单差额信息集合")
  private List<ExchangeDifferenceVo> differenceList;

  @ApiModelProperty("换货单附件信息集合")
  private List<ExchangeFileVo> fileList;

  @ApiModelProperty("退货单信息")
  private ReturnedGoodsVo returnedGoods;

  @ApiModelProperty("订单信息")
  private OrderVo order;
}

