package com.biz.crm.dms.business.exchange.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.dms.business.order.sdk.dto.OrderConfirmDto;
import com.biz.crm.dms.business.returned.goods.sdk.dto.goods.ReturnedGoodsDto;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 换货单主表实体dto
 *
 * @author xi.peng
 * @since 2022-07-06 19:03:27
 */
@Data
@ApiModel(value = "DmsOrderExchangeDto", description = "换货单主表实体dto")
public class ExchangeDto extends TenantFlagOpDto {

  /**
   * 暂存的草稿（0：否；1：是）
   */
  @ApiModelProperty("暂存的草稿（0：否；1：是）")
  private Boolean draft;

  @ApiModelProperty("原订单编号")
  private String originalOrderCode;

  @ApiModelProperty("原订单ID")
  private String originalOrderId;

  @ApiModelProperty("产生的订单编号")
  private String produceOrderCode;

  @ApiModelProperty("产生的订单ID")
  private String produceOrderId;

  @ApiModelProperty("产生的退货订单编号")
  private String produceReturnCode;

  @ApiModelProperty("产生的退货订单ID")
  private String produceReturnId;

  @ApiModelProperty("换货单编码")
  private String exchangeCode;

  @ApiModelProperty("换货单来源")
  private String exchangeSource;

  @ApiModelProperty("换货单状态")
  private String exchangeStatus;

  @ApiModelProperty("换货类型")
  private String exchangeType;

  @ApiModelProperty("换货时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  private Date exchangeTime;

  @ApiModelProperty("换货金额(元)")
  private BigDecimal exchangeAmount;

  @ApiModelProperty("换货数量")
  private BigDecimal exchangeQuantity;

  @ApiModelProperty("退货金额(元)")
  private BigDecimal returnAmount;

  @ApiModelProperty("退货数量")
  private BigDecimal returnQuantity;

  @ApiModelProperty("差额(元)")
  private BigDecimal differenceAmount;

  @ApiModelProperty("换货原因")
  private String reason;

  @ApiModelProperty("客户编码")
  private String customerCode;

  @ApiModelProperty("客户名称")
  private String customerName;

  //@ApiModelProperty("审批流程编码")
  //private String processKey;

  //@ApiModelProperty("审批单号")
  //private String processNumber;

  //@ApiModelProperty("审批备注")
  //private String processRemark;

  //@ApiModelProperty("审批状态")
  //private Integer processStatus;

  //@ApiModelProperty("菜单编码")
  //private String competenceCode;

  @ApiModelProperty("换货单附件集合信息")
  List<ExchangeFileDto> fileList;

  @ApiModelProperty("换货单差额集合信息")
  List<ExchangeDifferenceDto> differenceList;

  @ApiModelProperty("订单信息")
  OrderConfirmDto order;

  @ApiModelProperty("退货信息")
  ReturnedGoodsDto returnedGoods;

  /**
   * 工作流参数
   */
  @ApiModelProperty("工作流参数")
  private ProcessBusinessDto processBusiness;
}

