package com.biz.crm.dms.business.exchange.sdk.service;

import java.util.List;

import com.biz.crm.dms.business.exchange.sdk.dto.ExchangeFileDto;
import com.biz.crm.dms.business.exchange.sdk.vo.ExchangeFileVo;

/**
 * 换货单附件子表(DmsOrderExchangeFile)表服务接口
 *
 * @author xi.peng
 * @since 2022-07-07 09:35:52
 */
public interface ExchangeFileVoService {

  /**
   * 按换货单编码查询
   *
   * @param exchangeCode 换货单编码
   * @return List<DmsOrderExchangeFileVo>
   */
  List<ExchangeFileVo> findByExchangeCode(String exchangeCode);

  /**
   * 批量创建
   *
   * @param exchangeCode 换货单编码
   * @param dtoList 换货单附件dto集合
   */
  void createBatch(String exchangeCode, List<ExchangeFileDto> dtoList);

  /**
   * 批量更新
   *
   * @param dtoList 换货单附件dto集合
   */
  void updateBatch(List<ExchangeFileDto> dtoList);
}
