package com.biz.crm.dms.business.exchange.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 换货单差额子表Vo
 *
 * @author xi.peng
 * @since 2022-07-07 09:35:52
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "换货单差额子表Vo")
public class ExchangeDifferenceVo extends TenantFlagOpVo {

  @ApiModelProperty("换货单编码")
  private String exchangeCode;

  @ApiModelProperty("池子类型")
  private String poolType;

  @ApiModelProperty("指导在池子方的操作（金额正上账，负使用）")
  private String poolGuide;

  @ApiModelProperty("来源编码")
  private String sourceCode;

  @ApiModelProperty("来源绑定信息")
  private String sourceBind;

  @ApiModelProperty("金额(元)")
  private BigDecimal exchangeAmount;
}

