package com.biz.crm.dms.business.exchange.sdk.vo;

import com.biz.crm.dms.business.delivery.sdk.vo.DeliveryUnshippedVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 可换货-vo
 *
 * @author pengxi
 */
@Data
@ApiModel(value = "ExchangeableVo", description = "可换货-vo")
public class ExchangeableVo extends DeliveryUnshippedVo {

  /**
   * 原始订单编号
   */
  @ApiModelProperty("退货数量")
  private BigDecimal returnQuantity;

  /**
   * 是否可换货，true 可以；false 不可以（默认）
   */
  @ApiModelProperty("是否可换货，true 可以；false 不可以（默认）")
  private Boolean exchangeable=Boolean.FALSE;
}
