package com.biz.crm.dms.business.favorite.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.*;

/**
 * @Author: heguanyun
 * @Date: 2022/4/1 17:33
 * description:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FavoriteProductEntity", description = "收藏夹实体类")
@Entity
@TableName("dms_favorite_product")
@Table(name = "dms_favorite_product",
    uniqueConstraints = {@UniqueConstraint(name = "uk_relate_goods", columnNames = {"relate_code", "goods_code"})})
@org.hibernate.annotations.Table(appliesTo = "dms_favorite_product", comment = "收藏夹实体类")
public class FavoriteProductEntity extends TenantFlagOpEntity {

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  @TableField(value = "goods_code")
  @Column(name = "goods_code", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '商品编码'")
  private String goodsCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  @TableField(value = "goods_name")
  @Column(name = "goods_name", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '商品编码'")
  private String goodsName;

  /**
   * 关联编码
   */
  @ApiModelProperty("关联编码")
  @TableField(value = "relate_code")
  @Column(name = "relate_code", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '关联编码'")
  private String relateCode;
}
