package com.biz.crm.dms.business.favorite.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.dms.business.favorite.local.entity.FavoriteProductEntity;
import com.biz.crm.dms.business.favorite.local.mapper.FavoriteProductMapper;
import com.biz.crm.dms.business.favorite.sdk.dto.FavoriteProductDTO;
import com.biz.crm.mdm.business.product.spu.sdk.vo.FavoriteProductVO;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author: heguanyun
 * @Date: 2022/4/2 10:31
 * description:
 */
@Component
public class FavoriteProductRepository extends ServiceImpl<FavoriteProductMapper, FavoriteProductEntity> {

  @Autowired(required = false)
  private FavoriteProductMapper favoriteProductMapper;

  public Page<FavoriteProductVO> findFavorite(Pageable pageable, FavoriteProductDTO favoriteProductDTO) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    Page<FavoriteProductVO> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return favoriteProductMapper.findFavorite(page, DelFlagStatusEnum.NORMAL.getCode(), favoriteProductDTO);
  }

  public void deleteByGoodsCodeAndConsumerCode(String goodsCode, String consumerCode) {
    LambdaUpdateWrapper<FavoriteProductEntity> lambdaUpdateWrapper = new LambdaUpdateWrapper();
    lambdaUpdateWrapper.set(FavoriteProductEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .set(FavoriteProductEntity::getModifyTime, new Date())
        .set(FavoriteProductEntity::getModifyAccount, consumerCode)
        .eq(FavoriteProductEntity::getGoodsCode, goodsCode)
        .eq(FavoriteProductEntity::getRelateCode, consumerCode);
    this.update(lambdaUpdateWrapper);
  }

  public FavoriteProductEntity findByGoodsCodeAndConsumerCode(String goodsCode, String consumerCode) {
    LambdaQueryWrapper<FavoriteProductEntity> queryWrapper = new LambdaQueryWrapper<>();
    queryWrapper.eq(FavoriteProductEntity::getGoodsCode, goodsCode)
        .eq(FavoriteProductEntity::getRelateCode, consumerCode);
    return this.getOne(queryWrapper);
  }

  public List<String> filterFavoriteSpuCodes(String customerCode, Collection<String> spuCodes) {
    LambdaQueryWrapper<FavoriteProductEntity> queryWrapper = new LambdaQueryWrapper<>();
    queryWrapper.eq(FavoriteProductEntity::getRelateCode, customerCode)
        .eq(FavoriteProductEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .in(FavoriteProductEntity::getGoodsCode, spuCodes);
    List<FavoriteProductEntity> list = this.list(queryWrapper);
    if(CollectionUtils.isEmpty(list)){
      return Lists.newArrayList();
    }
    return list.stream().map(FavoriteProductEntity::getGoodsCode).collect(Collectors.toList());
  }
}
