package com.biz.crm.dms.business.favorite.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.favorite.sdk.dto.FavoriteProductDTO;
import com.biz.crm.dms.business.favorite.sdk.service.FavoriteProductService;
import com.biz.crm.dms.business.favorite.sdk.vo.FavoriteSpuVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author: heguanyun
 * @Date: 2022/4/1 18:02
 * description:
 */
@Slf4j
@RestController
@RequestMapping("/v1/favoriteProduct/favoriteProduct")
@Api(tags = "收藏夹: DeliveryVo: 收藏夹")
public class FavoriteProductController {

  @Autowired(required = false)
  private FavoriteProductService favoriteProductService;

  @ApiOperation(value = "添加收藏")
  @PostMapping
  public Result create(@RequestBody FavoriteProductDTO dto) {
    try {
      this.favoriteProductService.create(dto);
      return Result.ok("添加成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "删除收藏")
  @DeleteMapping
  public Result delete(@RequestParam("goodsCode") String goodsCode, @RequestParam("relateCode") String relateCode) {
    try {
      this.favoriteProductService.delete(goodsCode, relateCode);
      return Result.ok("删除收藏");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }



  @ApiOperation(value = "查询收藏列表")
  @GetMapping
  public Result<Page<FavoriteSpuVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable, FavoriteProductDTO favoriteProductDTO) {
    try {
      return Result.ok(this.favoriteProductService.findByConditions(pageable, favoriteProductDTO));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
