package com.biz.crm.dms.business.favorite.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleListTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.ValidateAllowSaleProductDto;
import com.biz.crm.dms.business.allow.sale.sdk.list.service.AllowSaleListVoService;
import com.biz.crm.dms.business.favorite.local.entity.FavoriteProductEntity;
import com.biz.crm.dms.business.favorite.local.repository.FavoriteProductRepository;
import com.biz.crm.dms.business.favorite.sdk.dto.FavoriteProductDTO;
import com.biz.crm.dms.business.favorite.sdk.service.FavoriteProductService;
import com.biz.crm.dms.business.favorite.sdk.vo.FavoriteSkuVo;
import com.biz.crm.dms.business.favorite.sdk.vo.FavoriteSpuVo;
import com.biz.crm.mdm.business.price.sdk.dto.FindPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.FindPriceUserTypeEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.product.spu.sdk.service.FavoriteProductVoService;
import com.biz.crm.mdm.business.product.spu.sdk.service.ProductSpuVoService;
import com.biz.crm.mdm.business.product.spu.sdk.vo.FavoriteProductVO;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @Author: heguanyun
 * @Date: 2022/4/1 18:07
 * description:
 */
@Slf4j
@Service
public class FavoriteProductServiceImpl implements FavoriteProductService {

  @Autowired(required = false)
  private FavoriteProductRepository favoriteProductRepository;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Autowired(required = false)
  private FavoriteProductVoService favoriteProductVoService;

  @Autowired(required = false)
  private ProductVoService productVoService;

  @Autowired(required = false)
  private ProductSpuVoService productSpuVoService;

  @Autowired(required = false)
  private PriceModelVoService priceModelVoService;

  @SuppressWarnings("AlibabaTransactionMustHaveRollback")
  @Override
  @Transactional
  public void create(FavoriteProductDTO dto) {
    String customerCode = dto.getRelateCode();
    Validate.isTrue(StringUtils.isNotBlank(dto.getGoodsCode()),"spu编码不能为空");
    FavoriteProductEntity exist = favoriteProductRepository.findByGoodsCodeAndConsumerCode(dto.getGoodsCode(), customerCode);
    if (Objects.nonNull(exist)) {
      //更新收藏数据
      exist.setModifyTime(new Date());
      exist.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      favoriteProductRepository.updateById(exist);
      return;
    }
    // 查询该spu是否存在
    List<ProductSpuVo> spuList = productSpuVoService.findBySpuCodes(Lists.newArrayList(dto.getGoodsCode()));
    Validate.isTrue(!CollectionUtils.isEmpty(spuList), "系统内不存在该spu");
    dto.setGoodsName(spuList.get(0).getSpuName());
    //保存收藏数据
    createValidate(dto);
    FavoriteProductEntity entity = new FavoriteProductEntity();
    entity.setRelateCode(customerCode);
    entity.setGoodsCode(dto.getGoodsCode());
    entity.setGoodsName(dto.getGoodsName());
    entity.setTenantCode(TenantUtils.getTenantCode());
    entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    entity.setRemark(dto.getRemark());
    favoriteProductRepository.save(entity);
  }

  private void createValidate(FavoriteProductDTO dto) {
    Validate.isTrue(StringUtils.isNotBlank(dto.getGoodsCode()),"spu编码不能为空");
    Validate.isTrue(StringUtils.isNotBlank(dto.getGoodsName()),"spu名称不能为空");
  }

  @Override
  @Transactional
  public void delete(String goodsCode, String relateCode) {
    favoriteProductRepository.deleteByGoodsCodeAndConsumerCode(goodsCode, relateCode);
  }

  @Override
  public Page<FavoriteSpuVo> findByConditions(Pageable pageable, FavoriteProductDTO favoriteProductDTO) {
    String customerCode = favoriteProductDTO.getRelateCode();
    Page<FavoriteProductVO> page = favoriteProductRepository.findFavorite(pageable, favoriteProductDTO);
    //调用mdm查询商品信息
    List<String> spuCodes = page.getRecords().stream().map(FavoriteProductVO::getProductCode).collect(Collectors.toList());
    List<FavoriteProductVO> spus = favoriteProductVoService.findDetailBySpuCodes(spuCodes);

    //查询价格信息
    Set<String> skuCodes = Sets.newHashSet();
    List<String> productCodes = Lists.newLinkedList();
    spus.forEach(spu -> {
      if(!CollectionUtils.isEmpty(spu.getSkus())){
        spu.getSkus().forEach(sku -> {
          skuCodes.add(sku.getProductCode());
          productCodes.add(sku.getProductCode());
        });
      }
    });
    if(!CollectionUtils.isEmpty(skuCodes)){
      FindPriceDto findPriceDto = new FindPriceDto();
      findPriceDto.setProductCodeSet(skuCodes);
      findPriceDto.setUserCode(customerCode);
      findPriceDto.setUserType(FindPriceUserTypeEnum.CUSTOMER.getDictCode());
      Map<String, PriceModelVo> price = priceModelVoService.findPrice(findPriceDto);
      spus.forEach(spu -> {
        if(!CollectionUtils.isEmpty(spu.getSkus())){
          List<BigDecimal> priceList = Lists.newArrayList();
          spu.getSkus().forEach(sku -> {
            if(Objects.nonNull(price.get(sku.getProductCode()))){
              sku.setPrice(price.get(sku.getProductCode()).getPrice());
              priceList.add(sku.getPrice());
            }
          });
          spu.setPriceShowList(priceList.stream().sorted().collect(Collectors.toList()));
        }
      });
    }
    // 查询可购的商品
    Set<String> allowSaleProductCodes = this.findAllowSaleProductCodes(customerCode, productCodes);
    // sku的图片
    List<ProductVo> productList = productVoService.findDetailsByIdsOrProductCodes(null, productCodes);
    Map<String, ProductVo> productCodeToVoMap = new HashMap<>(productList.size());
    for (ProductVo productVo : productList) {
      productCodeToVoMap.put(productVo.getProductCode(), productVo);
    }
    List<FavoriteSpuVo> favoriteSpuVos = (List<FavoriteSpuVo>) this.nebulaToolkitService.copyCollectionByBlankList( spus, FavoriteProductVO.class, FavoriteSpuVo.class, HashSet.class, LinkedList.class, "priceShowList");
    Map<String, List<BigDecimal>> spuToPriceMap = new HashMap<>(spus.size());
    for (FavoriteProductVO vo : spus) {
      spuToPriceMap.put(vo.getProductCode(), vo.getPriceShowList());
    }
    for (FavoriteSpuVo favoriteSpuVo : favoriteSpuVos) {
      List<FavoriteSkuVo> skus = favoriteSpuVo.getSkus();
      for (FavoriteSkuVo skuVo : skus) {
        String skuCode = skuVo.getProductCode();
        ProductVo productVo = productCodeToVoMap.get(skuCode);
        skuVo.setPictureMediaList(productVo.getPictureMediaList());
        skuVo.setVideoMediaList(productVo.getVideoMediaList());
        skuVo.setIsShelf(productVo.getIsShelf());
        skuVo.setIsAllowsale(allowSaleProductCodes.contains(skuCode));
        skuVo.setEnableStatus(productVo.getEnableStatus());
      }
      favoriteSpuVo.setPriceShowList(spuToPriceMap.get(favoriteSpuVo.getProductCode()));
    }
    Page<FavoriteSpuVo> favoriteSpuVoPage = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
    favoriteSpuVoPage.setRecords(favoriteSpuVos);
    return favoriteSpuVoPage;
  }

  @Override
  public List<String> filterFavoriteSpuCodes(String customerCode, Collection<String> spuCodes) {
    return favoriteProductRepository.filterFavoriteSpuCodes(customerCode,spuCodes);
  }

  @Autowired(required = false)
  private AllowSaleListVoService allowSaleListVoService;

  /**
   * 找到允许出售产品Code
   *
   * @param customerCode 客户代码
   * @param productCodes 产品代码
   * @return {@link List}<{@link String}>
   */
  private Set<String> findAllowSaleProductCodes(String customerCode, List<String> productCodes) {
    ValidateAllowSaleProductDto dto = new ValidateAllowSaleProductDto();
    dto.setBusinessCode(customerCode);
    dto.setListType(AllowSaleListTypeEnums.CUSTOMER.getCode());
    dto.setProductCodeList(productCodes);
    List<String> list = this.allowSaleListVoService.findAllowSaleProductCodes(dto);
    return Sets.newHashSet(list);
  }
}
