/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.favorite.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.dms.business.favorite.local.entity.FavoriteProductEntity;
import com.biz.crm.dms.business.favorite.local.mapper.FavoriteProductMapper;
import com.biz.crm.dms.business.favorite.sdk.dto.FavoriteProductDTO;
import com.biz.crm.mdm.business.product.spu.sdk.vo.FavoriteProductVO;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class FavoriteProductRepository
extends ServiceImpl<FavoriteProductMapper, FavoriteProductEntity> {
    @Autowired(required=false)
    private FavoriteProductMapper favoriteProductMapper;

    public Page<FavoriteProductVO> findFavorite(Pageable pageable, FavoriteProductDTO favoriteProductDTO) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.favoriteProductMapper.findFavorite((Page<FavoriteProductVO>)page, DelFlagStatusEnum.NORMAL.getCode(), favoriteProductDTO);
    }

    public void deleteByGoodsCodeAndConsumerCode(String goodsCode, String consumerCode) {
        LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)lambdaUpdateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).set(UuidOpEntity::getModifyTime, (Object)new Date())).set(UuidOpEntity::getModifyAccount, (Object)consumerCode)).eq(FavoriteProductEntity::getGoodsCode, (Object)goodsCode)).eq(FavoriteProductEntity::getRelateCode, (Object)consumerCode);
        this.update((Wrapper)lambdaUpdateWrapper);
    }

    public FavoriteProductEntity findByGoodsCodeAndConsumerCode(String goodsCode, String consumerCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(FavoriteProductEntity::getGoodsCode, (Object)goodsCode)).eq(FavoriteProductEntity::getRelateCode, (Object)consumerCode);
        return (FavoriteProductEntity)((Object)this.getOne((Wrapper)queryWrapper));
    }

    public List<String> filterFavoriteSpuCodes(String customerCode, Collection<String> spuCodes) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(FavoriteProductEntity::getRelateCode, (Object)customerCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(FavoriteProductEntity::getGoodsCode, spuCodes);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return list.stream().map(FavoriteProductEntity::getGoodsCode).collect(Collectors.toList());
    }
}

