/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.favorite.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleListTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.ValidateAllowSaleProductDto;
import com.biz.crm.dms.business.allow.sale.sdk.list.service.AllowSaleListVoService;
import com.biz.crm.dms.business.favorite.local.entity.FavoriteProductEntity;
import com.biz.crm.dms.business.favorite.local.repository.FavoriteProductRepository;
import com.biz.crm.dms.business.favorite.sdk.dto.FavoriteProductDTO;
import com.biz.crm.dms.business.favorite.sdk.service.FavoriteProductService;
import com.biz.crm.dms.business.favorite.sdk.vo.FavoriteSkuVo;
import com.biz.crm.dms.business.favorite.sdk.vo.FavoriteSpuVo;
import com.biz.crm.mdm.business.price.sdk.dto.FindPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.FindPriceUserTypeEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.product.spu.sdk.service.FavoriteProductVoService;
import com.biz.crm.mdm.business.product.spu.sdk.service.ProductSpuVoService;
import com.biz.crm.mdm.business.product.spu.sdk.vo.FavoriteProductVO;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class FavoriteProductServiceImpl
implements FavoriteProductService {
    private static final Logger log = LoggerFactory.getLogger(FavoriteProductServiceImpl.class);
    @Autowired(required=false)
    private FavoriteProductRepository favoriteProductRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private FavoriteProductVoService favoriteProductVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private ProductSpuVoService productSpuVoService;
    @Autowired(required=false)
    private PriceModelVoService priceModelVoService;
    @Autowired(required=false)
    private AllowSaleListVoService allowSaleListVoService;

    @Transactional
    public void create(FavoriteProductDTO dto) {
        String customerCode = dto.getRelateCode();
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getGoodsCode()), (String)"spu\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        FavoriteProductEntity exist = this.favoriteProductRepository.findByGoodsCodeAndConsumerCode(dto.getGoodsCode(), customerCode);
        if (Objects.nonNull((Object)exist)) {
            exist.setModifyTime(new Date());
            exist.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            this.favoriteProductRepository.updateById((Object)exist);
            return;
        }
        List spuList = this.productSpuVoService.findBySpuCodes((List)Lists.newArrayList((Object[])new String[]{dto.getGoodsCode()}));
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)spuList) ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u5185\u4e0d\u5b58\u5728\u8be5spu", (Object[])new Object[0]);
        dto.setGoodsName(((ProductSpuVo)spuList.get(0)).getSpuName());
        this.createValidate(dto);
        FavoriteProductEntity entity = new FavoriteProductEntity();
        entity.setRelateCode(customerCode);
        entity.setGoodsCode(dto.getGoodsCode());
        entity.setGoodsName(dto.getGoodsName());
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setRemark(dto.getRemark());
        this.favoriteProductRepository.save((Object)entity);
    }

    private void createValidate(FavoriteProductDTO dto) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getGoodsCode()), (String)"spu\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getGoodsName()), (String)"spu\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Transactional
    public void delete(String goodsCode, String relateCode) {
        this.favoriteProductRepository.deleteByGoodsCodeAndConsumerCode(goodsCode, relateCode);
    }

    public Page<FavoriteSpuVo> findByConditions(Pageable pageable, FavoriteProductDTO favoriteProductDTO) {
        String customerCode = favoriteProductDTO.getRelateCode();
        Page<FavoriteProductVO> page = this.favoriteProductRepository.findFavorite(pageable, favoriteProductDTO);
        List spuCodes = page.getRecords().stream().map(FavoriteProductVO::getProductCode).collect(Collectors.toList());
        List spus = this.favoriteProductVoService.findDetailBySpuCodes(spuCodes);
        HashSet skuCodes = Sets.newHashSet();
        LinkedList productCodes = Lists.newLinkedList();
        spus.forEach(spu -> {
            if (!CollectionUtils.isEmpty((Collection)spu.getSkus())) {
                spu.getSkus().forEach(sku -> {
                    skuCodes.add(sku.getProductCode());
                    productCodes.add(sku.getProductCode());
                });
            }
        });
        if (!CollectionUtils.isEmpty((Collection)skuCodes)) {
            FindPriceDto findPriceDto = new FindPriceDto();
            findPriceDto.setProductCodeSet((Set)skuCodes);
            findPriceDto.setUserCode(customerCode);
            findPriceDto.setUserType(FindPriceUserTypeEnum.CUSTOMER.getDictCode());
            Map price = this.priceModelVoService.findPrice(findPriceDto);
            spus.forEach(spu -> {
                if (!CollectionUtils.isEmpty((Collection)spu.getSkus())) {
                    ArrayList priceList = Lists.newArrayList();
                    spu.getSkus().forEach(sku -> {
                        if (Objects.nonNull(price.get(sku.getProductCode()))) {
                            sku.setPrice(((PriceModelVo)price.get(sku.getProductCode())).getPrice());
                            priceList.add(sku.getPrice());
                        }
                    });
                    spu.setPriceShowList(priceList.stream().sorted().collect(Collectors.toList()));
                }
            });
        }
        Set<String> allowSaleProductCodes = this.findAllowSaleProductCodes(customerCode, productCodes);
        List productList = this.productVoService.findDetailsByIdsOrProductCodes(null, (List)productCodes);
        HashMap<String, ProductVo> productCodeToVoMap = new HashMap<String, ProductVo>(productList.size());
        for (ProductVo productVo : productList) {
            productCodeToVoMap.put(productVo.getProductCode(), productVo);
        }
        List favoriteSpuVos = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)spus, FavoriteProductVO.class, FavoriteSpuVo.class, HashSet.class, LinkedList.class, new String[]{"priceShowList"});
        HashMap<String, List> spuToPriceMap = new HashMap<String, List>(spus.size());
        for (FavoriteProductVO vo : spus) {
            spuToPriceMap.put(vo.getProductCode(), vo.getPriceShowList());
        }
        for (FavoriteSpuVo favoriteSpuVo : favoriteSpuVos) {
            List skus = favoriteSpuVo.getSkus();
            for (FavoriteSkuVo skuVo : skus) {
                String skuCode = skuVo.getProductCode();
                ProductVo productVo = (ProductVo)productCodeToVoMap.get(skuCode);
                skuVo.setPictureMediaList(productVo.getPictureMediaList());
                skuVo.setVideoMediaList(productVo.getVideoMediaList());
                skuVo.setIsShelf(productVo.getIsShelf());
                skuVo.setIsAllowsale(Boolean.valueOf(allowSaleProductCodes.contains(skuCode)));
                skuVo.setEnableStatus(productVo.getEnableStatus());
            }
            favoriteSpuVo.setPriceShowList((List)spuToPriceMap.get(favoriteSpuVo.getProductCode()));
        }
        Page favoriteSpuVoPage = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        favoriteSpuVoPage.setRecords(favoriteSpuVos);
        return favoriteSpuVoPage;
    }

    public List<String> filterFavoriteSpuCodes(String customerCode, Collection<String> spuCodes) {
        return this.favoriteProductRepository.filterFavoriteSpuCodes(customerCode, spuCodes);
    }

    private Set<String> findAllowSaleProductCodes(String customerCode, List<String> productCodes) {
        ValidateAllowSaleProductDto dto = new ValidateAllowSaleProductDto();
        dto.setBusinessCode(customerCode);
        dto.setListType(AllowSaleListTypeEnums.CUSTOMER.getCode());
        dto.setProductCodeList(productCodes);
        List list = this.allowSaleListVoService.findAllowSaleProductCodes(dto);
        return Sets.newHashSet((Iterable)list);
    }
}

