package com.biz.crm.dms.business.favorite.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.favorite.sdk.dto.FavoriteProductDTO;
import com.biz.crm.dms.business.favorite.sdk.vo.FavoriteSpuVo;
import org.springframework.data.domain.Pageable;

import java.util.Collection;
import java.util.List;

/**
 * @Author: heguanyun
 * @Date: 2022/4/1 18:07
 * @description:DMS商城商品收藏夹Service
 */
public interface FavoriteProductService {

  /**
   * 收藏商品
   * @param dto
   */
  void create(FavoriteProductDTO dto);

  /**
   * 删除收藏
   * @param goodsCode
   */
  void delete(String goodsCode);

  /**
   * 查询收藏列表
   * @param pageable
   * @return
   */
  Page<FavoriteSpuVo> findByConditions(Pageable pageable, FavoriteProductDTO favoriteProductDTO);

  /**
   * 查询客户收藏的spu编码集合
   * @param customerCode
   * @param spuCodes
   * @return
   */
  List<String> filterFavoriteSpuCodes(String customerCode, Collection<String> spuCodes);
}
