package com.biz.crm.dms.business.favorite.sdk.vo;

import com.biz.crm.mdm.business.product.sdk.vo.ProductMediaVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 收藏夹用的sku模型
 *
 * @author hefan
 * @date 2022/05/16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "收藏夹用的sku模型")
public class FavoriteSkuVo {

  @ApiModelProperty("图片url")
  private String primaryPictureUrl;

  @ApiModelProperty("商品编码")
  private String productCode;

  @ApiModelProperty("商品名称")
  private String productName;

  @ApiModelProperty("价格")
  private BigDecimal price;

  @ApiModelProperty("spu价格区间")
  private List<BigDecimal> priceShowList;

  @ApiModelProperty("库存数量")
  private int stockNum;

  @ApiModelProperty("销售单位")
  private String saleUnit;

  @ApiModelProperty("规格")
  private String spec;

  @ApiModelProperty("基本单位")
  private String baseUnit;

  /** 图片信息 */
  @ApiModelProperty("附件信息，图片信息")
  private List<ProductMediaVo> pictureMediaList;

  /** 视频信息 */
  @ApiModelProperty("附件信息，视频信息")
  private List<ProductMediaVo> videoMediaList;

  /** 上下架状态 */
  @ApiModelProperty("上下架状态")
  private String isShelf;

  /** 是否允销 */
  @ApiModelProperty("是否允销")
  private Boolean isAllowsale;

  /** 启禁用状态 */
  @ApiModelProperty("启禁用状态")
  private String enableStatus;
}
