package com.biz.crm.dms.business.favorite.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 收藏夹，用的spu模型
 *
 * @author hefan
 * @date 2022/05/16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "收藏夹，用的spu模型")
public class FavoriteSpuVo {

  @ApiModelProperty("图片url")
  private String primaryPictureUrl;

  @ApiModelProperty("商品编码")
  private String productCode;

  @ApiModelProperty("商品名称")
  private String productName;

  @ApiModelProperty("价格")
  private BigDecimal price;

  @ApiModelProperty("spu价格区间")
  private List<BigDecimal> priceShowList;

  @ApiModelProperty("库存数量")
  private int stockNum;

  @ApiModelProperty("销售单位")
  private String saleUnit;

  @ApiModelProperty("规格")
  private String spec;

  @ApiModelProperty("基本单位")
  private String baseUnit;

  @ApiModelProperty("sku集合")
  private List<FavoriteSkuVo> skus;
}
