package com.biz.crm.dms.business.interaction.local.controller.carouselPicture;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.interaction.sdk.dto.carouselPicture.CarouselPicturePageDto;
import com.biz.crm.dms.business.interaction.sdk.service.carouselPicture.CarouselPictureVoService;
import com.biz.crm.dms.business.interaction.sdk.vo.carouselPicture.CarouselPictureVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@Api(tags = "客户互动: CarouselPictureVo: 轮播图")
@RequestMapping("/v1/carouselPicture/carouselPicture")
public class CarouselPictureVoController {
  @Autowired(required = false)
  CarouselPictureVoService carouselPictureVoService;

  @ApiOperation(value = "通过id查询图片信息")
  @GetMapping("/findById")
  public Result<CarouselPictureVo> findById(@RequestParam("id") String id) {
    try {
      return Result.ok(carouselPictureVoService.findById(id));
    } catch (RuntimeException e) {
      log.error(e.getMessage());
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "图片分页查询")
  @GetMapping("/findByConditions")
  public Result<Page<CarouselPictureVo>> findByConditions(@PageableDefault(size = 50) Pageable pageable, @ApiParam(name = "carouselPicturePageDto", value = "图片页面dto") CarouselPicturePageDto dto) {
    try {
      return Result.ok(carouselPictureVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage());
      return Result.error(e.getMessage());
    }
  }
}
