package com.biz.crm.dms.business.interaction.local.controller.complaint;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.interaction.local.entity.complaint.ComplaintEntity;
import com.biz.crm.dms.business.interaction.local.service.complaint.ComplaintService;
import com.biz.crm.dms.business.interaction.sdk.dto.complaint.ComplaintCustomerPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.complaint.ComplaintDto;
import com.biz.crm.dms.business.interaction.sdk.dto.complaint.ComplaintPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.complaint.ComplaintStateDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 客户互动: Complaint: 投诉建议管理
 *
 * @author ning.zhang
 * @date 2021/11/16
 */
@Slf4j
@RestController
@RequestMapping("/v1/complaint/complaint")
@Api(tags = "客户互动: Complaint: 投诉建议")
public class ComplaintController {

  @Autowired(required = false)
  private ComplaintService complaintService;

  /**
   * 新增投诉建议信息
   *
   * @param dto 参数dto
   * @return 新增投诉建议数据
   */
  @ApiOperation(value = "新增投诉建议")
  @PostMapping("")
  public Result<ComplaintEntity> create(@RequestBody ComplaintDto dto) {
    try {
      return Result.ok(this.complaintService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新投诉状态(解决,撤销)
   *
   * @param dto 参数dto
   * @return 操作结果
   */
  @ApiOperation(value = "更新投诉状态(解决,撤销)")
  @PatchMapping("")
  public Result<?> updateComplaintState(@RequestBody ComplaintStateDto dto) {
    try {
      this.complaintService.updateComplaintState(dto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新投诉状态
   * - 因为网关问题未修复好
   * - 为小程序不能发起patch请求
   *
   * @param dto 实体对象
   * @return 更新结果
   */
  @ApiOperation(value = "更新投诉状态")
  @PostMapping("updateComplaintStateTurnPatch")
  public Result<?> updateComplaintStateTurnPatch(@RequestBody ComplaintStateDto dto) {
    try {
      this.complaintService.updateComplaintState(dto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 投诉分页查询
   *
   * @param pageable 分页信息
   * @param dto      参数Dto
   * @return 投诉分页数据
   */
  @ApiOperation(value = "投诉分页查询")
  @GetMapping("/findByConditions")
  public Result<Page<ComplaintEntity>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                      @ApiParam(name = "ComplaintCustomerPageDto", value = "分页Dto") ComplaintPageDto dto) {
    try {
      return Result.ok(this.complaintService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 客户-投诉分页查询
   *
   * @param pageable 分页信息
   * @param dto      参数Dto
   * @return 投诉分页数据
   */
  @ApiOperation(value = "客户-投诉分页查询")
  @GetMapping("/findByComplaintCustomerPageDto")
  public Result<Page<ComplaintEntity>> findByComplaintCustomerPageDto(@PageableDefault(50) Pageable pageable,
                                                             @ApiParam(name = "ComplaintCustomerPageDto", value = "分页Dto") ComplaintCustomerPageDto dto) {
    try {
      return Result.ok(this.complaintService.findByComplaintCustomerPageDto(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
