package com.biz.crm.dms.business.interaction.local.controller.notice;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.interaction.local.service.notice.NoticeService;
import com.biz.crm.dms.business.interaction.sdk.dto.notice.NoticeDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 客户互动: Notice: 公告管理
 *
 * @author ning.zhang
 * @date 2021/11/16
 */
@Slf4j
@RestController
@RequestMapping("/v1/notice/notice")
@Api(tags = "客户互动: Notice: 公告管理")
public class NoticeController {

  @Autowired(required = false)
  private NoticeService noticeService;

  /**
   * 新增公告信息
   *
   * @param dto 参数dto
   * @return 新增公告数据
   */
  @ApiOperation(value = "新增公告")
  @PostMapping("")
  public Result create(@RequestBody NoticeDto dto) {
    try {
      return Result.ok(this.noticeService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新公告信息
   *
   * @param dto 参数dto
   * @return 更新后公告数据
   */
  @ApiOperation(value = "更新公告信息")
  @PatchMapping("")
  public Result update(@RequestBody NoticeDto dto) {
    try {
      return Result.ok(this.noticeService.update(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除公告
   *
   * @param ids 公告id集合
   * @return 操作结果
   */
  @ApiOperation(value = "删除")
  @DeleteMapping("/deleteBatch")
  public Result deleteBatch(@RequestParam("ids") List<String> ids) {
    try {
      this.noticeService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用公告
   *
   * @param ids 公告id集合
   * @return 操作结果
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enableBatch")
  public Result enableBatch(@RequestBody List<String> ids) {
    try {
      this.noticeService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用公告
   *
   * @param ids 公告id集合
   * @return 操作结果
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disableBatch")
  public Result disableBatch(@RequestBody List<String> ids) {
    try {
      this.noticeService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
