package com.biz.crm.dms.business.interaction.local.controller.notice;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.interaction.sdk.dto.notice.NoticeCustomerPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.notice.NoticePageDto;
import com.biz.crm.dms.business.interaction.sdk.service.notice.NoticeVoService;
import com.biz.crm.dms.business.interaction.sdk.vo.notice.NoticeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 客户互动: NoticeVo: 公告管理
 *
 * @author ning.zhang
 * @date 2021/11/16
 */
@Slf4j
@RestController
@RequestMapping("/v1/notice/notice")
@Api(tags = "客户互动: NoticeVo: 公告管理")
public class NoticeVoController {

  @Autowired(required = false)
  private NoticeVoService noticeVoService;

  /**
   * 公告分页查询
   * @param pageable 分页信息
   * @param dto 参数Dto
   * @return 公告分页数据
   */
  @ApiOperation(value = "公告分页查询")
  @GetMapping("/findByConditions")
  public Result<Page<NoticeVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                 @ApiParam(name = "NoticePageDto", value = "分页Dto") NoticePageDto dto) {
    try {
      return Result.ok(this.noticeVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 客户-公告分页查询
   *
   * @param pageable 分页信息
   * @param dto      参数Dto
   * @return 公告分页数据
   */
  @ApiOperation(value = "客户-公告分页查询")
  @GetMapping("/findByNoticeCustomerPageDto")
  public Result<Page<NoticeVo>> findByNoticeCustomerPageDto(@PageableDefault(50) Pageable pageable,
                                                            @ApiParam(name = "NoticeCustomerPageDto", value = "分页Dto") NoticeCustomerPageDto dto) {
    try {
      return Result.ok(this.noticeVoService.findByNoticeCustomerPageDto(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过ID获取公告信息
   *
   * @param id 公告ID
   * @return 操作结果
   */
  @ApiOperation(value = "通过ID获取公告信息")
  @GetMapping("/findById")
  public Result<NoticeVo> findById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      return Result.ok(this.noticeVoService.findById(id));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
