package com.biz.crm.dms.business.interaction.local.entity.complaint;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

/**
 * 投诉实体类
 *
 * @author ning.zhang
 * @date 2021/11/24
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ComplaintEntity", description = "投诉实体类")
@Entity
@TableName("dms_complaint")
@Table(name = "dms_complaint", indexes = {
    @Index(name = "dms_complaint_index1", columnList = "tenant_code,complaint_code",unique = true),
    @Index(name = "dms_complaint_index2", columnList = "complaint_code"),
    @Index(name = "dms_complaint_index3", columnList = "customer_code"),
})
@org.hibernate.annotations.Table(appliesTo = "dms_complaint", comment = "投诉表")
public class ComplaintEntity extends TenantOpEntity {


  private static final long serialVersionUID = 7055089433804455586L;

  /**
   * 投诉编码
   */
  @ApiModelProperty("投诉编码")
  @Column(name = "complaint_code", length = 64, columnDefinition = "VARCHAR(128) COMMENT '投诉编码'")
  private String complaintCode;

  /**
   * 投诉标题
   */
  @ApiModelProperty("投诉标题")
  @Column(name = "complaint_title", length = 128, columnDefinition = "VARCHAR(128) COMMENT '投诉标题'")
  private String complaintTitle;

  /**
   * 投诉类型
   */
  @ApiModelProperty("投诉类型")
  @Column(name = "complaint_type", length = 10, columnDefinition = "VARCHAR(10) COMMENT '投诉类型'")
  private String complaintType;

  /**
   * 投诉状态(0:待厂家处理,1:待客户回复,2:已解决,3:已撤销)
   */
  @ApiModelProperty("投诉状态(0:待厂家处理,1:待客户回复,2:已解决,3:已撤销)")
  @Column(name = "complaint_state", length = 10, columnDefinition = "VARCHAR(10) COMMENT '投诉状态(0:待厂家处理,1:待客户回复,2:已解决,3:已撤销)'")
  private String complaintState;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @Column(name = "customer_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户编码'")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  @Column(name = "customer_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称'")
  private String customerName;

  /**
   * 投诉内容
   */
  @ApiModelProperty("投诉内容")
  @Column(name = "complaint_content", length = 500, columnDefinition = "VARCHAR(500) COMMENT '投诉内容'")
  private String complaintContent;

  /**
   * 投诉人联系方式
   */
  @ApiModelProperty("投诉人联系方式")
  @Column(name = "complainant_contact", length = 30, columnDefinition = "VARCHAR(30) COMMENT '投诉人联系方式'")
  private String complainantContact;

  /**
   * 投诉文件关联信息
   */
  @ApiModelProperty("投诉文件关联信息")
  @Transient
  @TableField(exist = false)
  private List<ComplaintFileEntity> fileList;

  /**
   * 投诉回复关联信息
   */
  @ApiModelProperty("投诉回复关联信息")
  @Transient
  @TableField(exist = false)
  private List<ComplaintReplyEntity> replyList;
}
